/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1247")
@CheckName(value="R.1247")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.SEQUENCE_ITEM, RuleLabel.SUBSCRIBER, RuleLabel.VERIFICATION})
@CheckTitle(value="Locally clone the sequence item in the subscriber")
@CheckDescription(value="Locally clone the sequence item in the subscriber in case it is needed for later purpose.\nWhen a write function is called by an analysis port, the sequence item is send.\nSo when a monitor modifies the sequence item, it could affect the sequence item in subscriber.\n\nExample:\n\nclass my_subscriber extends xvm_subscriber#(mem_seq_item);\n\tmem_seq_item item1;\n\n\tvirtual function void write(mem_seq_item item0);\n\t\titem1 = mem_seq_item::type_id::create(\"item1\");\n\t\titem1.copy(item0);\n\tendfunction : write\n\nendclass\n\nNot allowed:\n\nclass my_subscriber2 extends xvm_subscriber#(mem_seq_item);\n\tmem_seq_item item1;\n\n\tvirtual function void write(mem_seq_item item0);\n\t\titem1 = mem_seq_item::type_id::create(\"item1\");\n\tendfunction : write\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1247
extends OVMComplianceCheck {
    RfClass sequenceItemClass;
    RfClass subscriberClass;
    boolean isCloned;

    public Check_R_1247(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String lib = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        this.subscriberClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_subscriber", true);
        this.sequenceItemClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_sequence_item", true);
        if (this.subscriberClass == null || this.sequenceItemClass == null) {
            return;
        }
        Set<RfClass> allSubscribers = this.fOVMProject.getAllXVMSubClasses(this.subscriberClass);
        for (RfClass rfClass : allSubscribers) {
            if (this.checkPreWaivers(rfClass.getFile())) continue;
            this.checkClass(rfClass);
        }
    }

    public void checkClass(RfNamedElement element) {
        if (!(element instanceof RfClass)) {
            return;
        }
        this.notifyCheckAlive();
        RfFunction function = ((RfClass)element).getLocalFunction("write");
        if (function == null) {
            return;
        }
        this.isCloned = false;
        function.visitHidObject(this.fOVMProject.getRfProject(), new LocalVisitor());
        if (!this.isCloned) {
            this.addHit(function.getNamedElement(), "The sequence item should be locally cloned in the 'write' method of the subscriber for later use!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    protected class LocalVisitor
    implements IHidVisitor<IHidObject> {
        private RfNamedElement scope;

        public boolean visit(IHidObject iHidObject) {
            if (this.scope.isPredefined()) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (Check_R_1247.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            Check_R_1247.this.notifyCheckAlive();
            if (iHidObject instanceof RfHidAccess) {
                RfHidAccess hidObject = (RfHidAccess)iHidObject;
                IRfNamedElement associatedType = hidObject.getAssociatedType();
                if (!(associatedType instanceof RfClass)) {
                    return true;
                }
                if (!LintUtils.isSubClassOf((RfClass)associatedType, Check_R_1247.this.sequenceItemClass)) {
                    return true;
                }
                ListContainer hids = hidObject.getHids();
                if (hids == null || hids.isEmpty() || hids.size() != 1) {
                    return true;
                }
                if (!(hids.get(0) instanceof RfHid)) {
                    return true;
                }
                RfHid hid = (RfHid)((Object)hids.get(0));
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement hidElement = hid.getElement();
                if (!(hidElement instanceof RfFunction)) {
                    return true;
                }
                String fullName = ((RfFunction)hidElement).getFullName();
                if (!fullName.equals("uvm_pkg::uvm_object.clone") && !fullName.equals("uvm_pkg::uvm_object.copy")) {
                    return true;
                }
                Check_R_1247.this.isCloned = true;
                return false;
            }
            if (iHidObject instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)iHidObject;
                if (!operator.isAssignment()) {
                    return true;
                }
                IHidObject lhHidOb = operator.getLHValue();
                if (!(lhHidOb instanceof RfHid)) {
                    return true;
                }
                RfHid lhHid = (RfHid)lhHidOb;
                IRfNamedElement lhElement = lhHid.getElement();
                if (!(lhElement instanceof RfField)) {
                    return true;
                }
                RfClass filedType = LintUtils.getFieldFinalClassTypeOrNull((RfField)lhElement);
                if (!LintUtils.isSubClassOf(filedType, Check_R_1247.this.sequenceItemClass)) {
                    return true;
                }
                IHidObject rhHidOb = operator.getFirstRHValue();
                if (!(rhHidOb instanceof RfHid)) {
                    return true;
                }
                RfHid rhHid = (RfHid)rhHidOb;
                IRfNamedElement rhElement = rhHid.getElement();
                if (!(rhElement instanceof RfField)) {
                    return true;
                }
                filedType = LintUtils.getFieldFinalClassTypeOrNull((RfField)rhElement);
                if (!LintUtils.isSubClassOf(filedType, Check_R_1247.this.sequenceItemClass)) {
                    return true;
                }
                Check_R_1247.this.isCloned = true;
                return false;
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

