/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.1.22")
@CheckID(value="R.1248")
@CheckName(value="R.1248")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FIELD, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="In a sequence use the built-in transaction variables req and rsp")
@CheckDescription(value="Sequences that directly extend from xvm_sequence and child classes of such sequences must not have fields of type extending from xvm_sequence_item.\n\nExamples:\n\nclass my_sequence extends xvm_sequence#(my_sequence_item);\n    my_sequence_item my_item;     // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1248
extends OVMComplianceCheck {
    public Check_R_1248(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.fOvmSequence;
        RfClass sequenceItemClass = this.fOVMProject.fOvmSequenceItem;
        RfClass sequenceBaseClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_base"), true);
        if (baseClass == null || sequenceItemClass == null || sequenceBaseClass == null) {
            return;
        }
        HashSet<RfClass> firstLevelSequences = new HashSet<RfClass>();
        Set<RfClass> children = baseClass.getChildren();
        if (children != null && !children.isEmpty()) {
            firstLevelSequences.addAll(children);
        }
        if (firstLevelSequences.isEmpty()) {
            return;
        }
        firstLevelSequences.addAll(baseClass.getSpecializations());
        HashSet<RfClass> secondLevelSequences = new HashSet<RfClass>();
        for (RfClass firstLevelSequence : firstLevelSequences) {
            this.notifyCheckAlive();
            children = firstLevelSequence.getChildren();
            if (children != null && !children.isEmpty()) {
                secondLevelSequences.addAll(children);
            }
            if (this.checkPreWaivers(firstLevelSequence.getFile()) || firstLevelSequence.getParent() == null || !firstLevelSequence.getParent().getFullName().equals(baseClass.getFullName())) continue;
            firstLevelSequence.accept(null, new LocalNamedElementVisitor(firstLevelSequence, sequenceItemClass, sequenceBaseClass));
        }
        for (RfClass secondLevelSequence : secondLevelSequences) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(secondLevelSequence.getFile()) || secondLevelSequence.getParent() == null || secondLevelSequence.getParent().getParent() == null || !secondLevelSequence.getParent().getParent().getFullName().equals(baseClass.getFullName())) continue;
            secondLevelSequence.accept(null, new LocalNamedElementVisitor(secondLevelSequence, sequenceItemClass, sequenceBaseClass));
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private RfClass clazz;
        private RfClass sequenceItemClass;
        private RfClass sequenceBaseClass;

        public LocalNamedElementVisitor(RfClass clazz, RfClass sequenceItemClass, RfClass sequenceBaseClass) {
            this.clazz = clazz;
            this.sequenceItemClass = sequenceItemClass;
            this.sequenceBaseClass = sequenceBaseClass;
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)namedElement;
            if (!field.isField()) {
                return true;
            }
            RfClass classType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (classType == null || !LintUtils.isSubClassOf(classType, this.sequenceItemClass) || LintUtils.isSubClassOf(classType, this.sequenceBaseClass)) {
                return true;
            }
            Check_R_1248.this.addHit(field, "Sequence item field '" + field.getName() + "' in '" + LintUtils.getNamedElementFullName(this.clazz) + "' class!");
            return true;
        }
    }
}

