/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1249")
@CheckName(value="R.1249")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.MONITOR, RuleLabel.RUN_PHASE, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="A monitor must make sure the collected sequence item is sent after each transaction is captured")
@CheckDescription(value="In the run phase of the monitor there must be an analysis_port.write(seq_item) called after the sequence item assignments.\n\nExamples:\n\nclass monitor extends uvm_monitor;\n  virtual add_if vif;\n  uvm_analysis_port #(mem_seq_item) item_collect_port;\n  mem_seq_item mon_item;\n  `uvm_component_utils(monitor)\n\n  task run_phase (uvm_phase phase);\n    forever begin\n      if(vif.monitor_cb.wr_en) begin\n        mon_item.wr_en = vif.monitor_cb.wr_en;\n      end\n      item_collect_port.write(mon_item);\n    end\n  endtask\n\nendclass\n\nNot allowed:\nclass monitor extends uvm_monitor;\n  virtual add_if vif;\n  uvm_analysis_port #(mem_seq_item) item_collect_port;\n  mem_seq_item mon_item;\n  `uvm_component_utils(monitor)\n\n  task run_phase (uvm_phase phase);\n    forever begin\n      item_collect_port.write(mon_item);\n      if(vif.monitor_cb.wr_en) begin\n        mon_item.wr_en = vif.monitor_cb.wr_en;\n      end\n    end\n  endtask\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1249
extends OVMComplianceCheck {
    int runPhaseFunctionLine;
    boolean hasWrite;
    Set<RfClass> allMonitors = new LinkedHashSet<RfClass>();
    Set<RfClass> allSequenceItems = new HashSet<RfClass>();
    Map<RfField, DVTPair<Integer, Integer>> sequenceItemsToLinesMap = new LinkedHashMap<RfField, DVTPair<Integer, Integer>>();

    public Check_R_1249(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.allMonitors = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmMonitor);
        this.allSequenceItems = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequenceItem);
        if (this.allMonitors.isEmpty() || this.allSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.allMonitors) {
            this.checkRunMethod(monitor);
        }
    }

    private void checkRunMethod(RfClass component) {
        this.notifyCheckAlive();
        if (this.checkPreWaivers(component.getFile())) {
            return;
        }
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        RfFunction runPhaseFunction = component.getLocalMember(RfFunction.class, xvmRunPhaseMethodName, false);
        if (runPhaseFunction == null) {
            return;
        }
        this.runPhaseFunctionLine = runPhaseFunction.getLine();
        this.sequenceItemsToLinesMap.clear();
        runPhaseFunction.visitHidObject(this.fOVMProject.getRfProject(), new LocalAccessesVisitor());
        runPhaseFunction.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new LocalAssignmentsVisitor());
        if (!this.hasWrite) {
            this.addHit(component.getFile().getParserPath(), this.runPhaseFunctionLine, "No collected sequence item has been sent in the run phase of the component '" + LintUtils.getNamedElementFullName(component.getNamedElement()) + "'!", null);
        } else {
            for (Map.Entry<RfField, DVTPair<Integer, Integer>> entry : this.sequenceItemsToLinesMap.entrySet()) {
                RfField sequenceItem = entry.getKey();
                DVTPair<Integer, Integer> lines = entry.getValue();
                Integer assignmentLine = (Integer)lines.getValue();
                Integer writeLine = (Integer)lines.getKey();
                if (writeLine >= assignmentLine) continue;
                this.addHit(component.getFile().getParserPath(), assignmentLine, "The sequence item '" + LintUtils.getNamedElementFullName(sequenceItem.getNamedElement()) + "' has not been sent after the last assignment!", null);
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    protected class LocalAccessesVisitor
    extends RfHidAccessVisitor {
        public LocalAccessesVisitor() {
            Check_R_1249.this.hasWrite = false;
        }

        public boolean visit(RfHidAccess hidAccess) {
            IRfNamedElement associatedType = hidAccess.getAssociatedType();
            if (associatedType == null) {
                return true;
            }
            if (this.isAnalysisPort(associatedType)) {
                Hid method = hidAccess.getFirstHid();
                if (method.getName().equals("write")) {
                    Check_R_1249.this.hasWrite = true;
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)method);
                    if (methodCalls == null || methodCalls.isEmpty()) {
                        return true;
                    }
                    MethodCall methodCall = (MethodCall)methodCalls.get(0);
                    if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                        return true;
                    }
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        RfField sequenceItemArgField;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!(key instanceof RfField) || !(sequenceItemArgField = (RfField)key).getName().equals("t")) continue;
                        IHidObject sequenceItem = (IHidObject)entry.getValue();
                        if (!(sequenceItem instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement sequenceItemElement = ((RfHid)sequenceItem).getElement();
                        if (!(sequenceItemElement instanceof RfField)) {
                            return true;
                        }
                        RfField sequenceItemField = (RfField)sequenceItemElement;
                        DVTPair currentLines = Check_R_1249.this.sequenceItemsToLinesMap.get(sequenceItemField);
                        if (currentLines == null) {
                            currentLines = new DVTPair((Object)method.getLine(), (Object)(method.getLine() - 1));
                            Check_R_1249.this.sequenceItemsToLinesMap.put(sequenceItemField, (DVTPair<Integer, Integer>)currentLines);
                        }
                        currentLines.setKey((Object)method.getLine());
                    }
                    return true;
                }
            } else if (Check_R_1249.this.allSequenceItems.contains(associatedType)) {
                Hid method = hidAccess.getFirstHid();
                if (method == null) {
                    return true;
                }
                if (method.getName().startsWith("set")) {
                    Hid sequenceItem = hidAccess.getParentHid();
                    if (!(sequenceItem instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement sequenceItemElement = sequenceItem.getElement();
                    if (!(sequenceItemElement instanceof RfField)) {
                        return true;
                    }
                    RfField sequenceItemField = (RfField)sequenceItemElement;
                    DVTPair<Integer, Integer> currentLines = Check_R_1249.this.sequenceItemsToLinesMap.get(sequenceItemField);
                    if (currentLines == null) {
                        return true;
                    }
                    if (sequenceItem.getLine() > (Integer)currentLines.getValue()) {
                        currentLines.setValue((Object)sequenceItem.getLine());
                    }
                    return true;
                }
            }
            return true;
        }

        private boolean isAnalysisPort(IRfNamedElement associatedType) {
            return ((Check_R_1249)Check_R_1249.this).fOVMProject.fOvmAnalysisPort.getName().equals(associatedType.getName());
        }
    }

    protected class LocalAssignmentsVisitor
    extends HidOperatorVisitor {
        public LocalAssignmentsVisitor() {
            super(null);
        }

        public boolean visit(HidOperator hidOperator) {
            if (!hidOperator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)lhValue;
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfField)) {
                    return true;
                }
                IRfNamedElement fieldType = ((RfField)element).getAssociatedType();
                if (Check_R_1249.this.allSequenceItems.contains(fieldType)) {
                    DVTPair<Integer, Integer> currentLines = Check_R_1249.this.sequenceItemsToLinesMap.get(element);
                    if (currentLines == null) {
                        return true;
                    }
                    if (hid.getLine() > (Integer)currentLines.getValue()) {
                        currentLines.setValue((Object)hid.getLine());
                    }
                }
            } else {
                Hid parentHid = parentAccess.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = parentHid.getElement();
                if (!(element instanceof RfField)) {
                    return true;
                }
                IRfNamedElement fieldType = ((RfField)element).getAssociatedType();
                if (Check_R_1249.this.allSequenceItems.contains(fieldType)) {
                    DVTPair<Integer, Integer> currentLines = Check_R_1249.this.sequenceItemsToLinesMap.get(element);
                    if (currentLines == null) {
                        return true;
                    }
                    if (hid.getLine() > (Integer)currentLines.getValue()) {
                        currentLines.setValue((Object)hid.getLine());
                    }
                }
            }
            return true;
        }
    }
}

