/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1250")
@CheckName(value="R.1250")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.CONFIG_DB, RuleLabel.TOP_MODULE, RuleLabel.VERIFICATION})
@CheckTitle(value="Put virtual interfaces into the configuration database")
@CheckDescription(value="In the top module, check that all interface instances have uvm_config_db::set parameterized with virtual interface called.\nArrays of interfaces should always be set inside a loop, to ensure that all the interfaces of said array are properly set.\n\nExamples:\nmodule top_module;\n  test_interface a_interface();              // not allowed\n  test_interface b_interface();              // allowed\n\n  test_interface c_array_interface[0 : 2](); // not allowed\n  test_interface d_array_interface[0 : 2](); // allowed\n\n  initial begin\n    uvm_pkg::uvm_config_db#(virtual test_interface)::set(null, \"uvm_test_top\", \"vif\", b_interface);\n    uvm_pkg::uvm_config_db#(virtual test_interface)::set(null, \"uvm_test_top\", \"vif\", c_array_interface[0]);\n\n\t  foreach (array_interface[i]) begin\n  \tuvm_pkg::uvm_config_db#(virtual test_interface)::set(null, \"uvm_test_top\", \"vif\", d_array_interface[i]);\n\t  end\n  end\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1250
extends OVMComplianceCheck {
    Set<RfInstance> interfaces;
    Set<RfInstance> arrayInterfaces;

    public Check_R_1250(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.interfaces = new HashSet<RfInstance>();
        this.arrayInterfaces = new HashSet<RfInstance>();
        Set<RfNamedElement> topModules = LintUtils.getTopModulesCallingRunTest(this.fOVMProject);
        if (topModules == null || topModules.isEmpty()) {
            this.addHit(null, "There is no top module!");
            return;
        }
        for (RfNamedElement module : topModules) {
            List<RfInstance> instances;
            if (module == null || !(module instanceof RfModule) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(module.getDeclaration().getParserPath(), this) || (instances = module.getInstancesWithPrefix("", 2, 1)) == null || instances.isEmpty()) continue;
            for (RfInstance instance : instances) {
                RfNamedElement associatedType;
                if (instance == null || !((associatedType = LintUtils.getAssociatedFinalType(instance)) instanceof RfInterface)) continue;
                if (instance.isArray()) {
                    this.arrayInterfaces.add(instance);
                    continue;
                }
                this.interfaces.add(instance);
            }
            if (this.interfaces.isEmpty() && this.arrayInterfaces.isEmpty()) continue;
            module.visitHidObject(null, new LocalHidVisitor());
        }
        for (RfInstance instance : this.interfaces) {
            this.addHit(instance, "Interface '" + LintUtils.getNamedElementFullName(instance) + "' must be put into the configuration database!");
        }
        for (RfInstance instance : this.arrayInterfaces) {
            this.addHit(instance, "Interface array '" + LintUtils.getNamedElementFullName(instance) + "' must be put into the configuration database inside a loop!");
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        private LocalHidVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            Check_R_1250.this.notifyCheckAlive();
            String name = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_R_1250.this.fOVMProject.isOVMFile(name)) {
                return true;
            }
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)hidObject;
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            this.checkSetCall(hid);
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        private void checkSetCall(RfHid rfHid) {
            if (!"uvm_pkg::uvm_config_db.set".equals(LintUtils.getHidFullName((IHid)rfHid))) {
                return;
            }
            HidAccess parentAccess = rfHid.getParentAccess();
            if (parentAccess == null) {
                return;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (associatedType == null || !(associatedType instanceof RfSpecializedClass)) {
                return;
            }
            Map<String, IELParamValue> parameterValues = ((RfSpecializedClass)associatedType).getLocalElabConstantValues();
            if (parameterValues == null || parameterValues.isEmpty()) {
                return;
            }
            boolean interfaceCheck = false;
            for (IELParamValue paramValue : parameterValues.values()) {
                IRfNamedElement namedElement;
                if (paramValue == null || (namedElement = paramValue.getNamedElement()) == null || !(namedElement instanceof RfInterface)) continue;
                interfaceCheck = true;
            }
            if (!interfaceCheck) {
                return;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    RfHid valueHid;
                    IRfNamedElement valueElement;
                    IHidObject value;
                    RfField configField;
                    IRfNamedElement key = (IRfNamedElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("value") || (value = (IHidObject)entry.getValue()) == null) continue;
                    boolean isArray = false;
                    if (value instanceof RfHidAccess && ((RfHidAccess)value).getParentHid() != null) {
                        isArray = true;
                        if (this.isInsideLoop()) {
                            value = ((RfHidAccess)value).getParentHid();
                        }
                    }
                    if (!(value instanceof RfHid) || (valueElement = (valueHid = (RfHid)value).getElement()) == null || !(valueElement instanceof RfField)) continue;
                    if (isArray) {
                        Check_R_1250.this.arrayInterfaces.remove(valueElement);
                        continue;
                    }
                    Check_R_1250.this.interfaces.remove(valueElement);
                }
            }
        }

        private boolean isInsideLoop() {
            IRfNamedElement enclosingScope = this.scope;
            while (enclosingScope != null && !(enclosingScope instanceof RfModule)) {
                if (enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isLoop()) {
                    return true;
                }
                if (enclosingScope instanceof RfGenerateBlock && ((RfGenerateBlock)enclosingScope).isLoopGenerate()) {
                    return true;
                }
                enclosingScope = (IRfNamedElement)enclosingScope.getEnclosingScope();
            }
            return false;
        }
    }
}

