/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1251")
@CheckName(value="R.1251")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.TEST, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Test classes must set the configuration object")
@CheckDescription(value="Classes extending from xvm_test must have a config object and must set at least one value for it.\n\nExamples:\n\nconfig_class cfg;\nfunction void build_phase(uvm_phase phase);\n    cfg.field = 0;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1251
extends AbstractConfigClassCheck {
    public Check_R_1251(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        if (this.fOVMProject.fOvmTest == null) {
            return;
        }
        this.checkTestClass(this.fOVMProject.fOvmTest, false);
    }

    private void checkTestClass(RfClass testClass, boolean hasParentWithConfigObject) {
        Set<RfClass> allTestClasses = testClass.getChildren();
        if (allTestClasses == null) {
            return;
        }
        for (RfClass test : allTestClasses) {
            boolean hasConfigObjects;
            this.notifyCheckAlive();
            RfFileDef file = test.getFile();
            if (file == null) {
                return;
            }
            if (this.checkPreWaivers(file.getParserPath())) continue;
            HashSet<RfField> configObjects = new HashSet<RfField>();
            List<RfField> fields = test.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields != null && !fields.isEmpty()) {
                for (RfField field : fields) {
                    RfClass clazz;
                    if (this.fOVMProject.isOVMElement(field) || (clazz = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !this.checkConfigClass(clazz)) continue;
                    configObjects.add(field);
                }
            }
            boolean bl = hasConfigObjects = configObjects != null && !configObjects.isEmpty();
            if (!hasParentWithConfigObject && !hasConfigObjects) {
                this.addHit(test, "Missing config object in '" + LintUtils.getNamedElementFullName(test) + "' class!");
                this.checkTestClass(test, false);
                continue;
            }
            test.visitHidObject(null, new AssignmentVisior(configObjects));
            for (RfField configObject : configObjects) {
                this.addHit(configObject, "Config object not set: '" + LintUtils.getNamedElementFullName(configObject) + "' of type '" + LintUtils.getNamedElementFullName(LintUtils.getFieldFinalClassTypeOrNull(configObject)) + "'!");
            }
            this.checkTestClass(test, hasParentWithConfigObject || hasConfigObjects);
        }
    }

    private class AssignmentVisior
    implements IHidVisitor<RfHidOperator> {
        private Set<RfField> configObjects;

        public AssignmentVisior(Set<RfField> configObject) {
            this.configObjects = configObject;
        }

        public boolean visit(RfHidOperator hidObject) {
            HidAccess hidAccess;
            if (!hidObject.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            Hid hid = (Hid)lhValue;
            if ((hid = hid.getAncestorHid()) == null) {
                return true;
            }
            if (hid.getElement() instanceof RfThisImplicitVariable && (hidAccess = hid.getFirstAccess()) != null && hidAccess.getFirstHid() != null) {
                hid = hidAccess.getFirstHid();
            }
            if (!(hid.getElement() instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)hid.getElement();
            if (this.configObjects.contains(field)) {
                this.configObjects.remove(field);
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

