/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1252")
@CheckName(value="R.1252")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.TOP_MODULE, RuleLabel.VERIFICATION, RuleLabel.CONFIG_DB})
@CheckTitle(value="Testbench top module must call uvm_config_db::set with \"uvm_test_top\" as scope")
@CheckDescription(value="This rule checks if the tesbench top module calls uvm_config_db::set with \"uvm_test_top\" as scope\n\nExamples:\n\nmodule example_top module; //allowed\n  function example_function()\n    uvm_config_db#(example_class)::set(component_class, \"uvm_test_top\", \"cfg\", example_object);\n  endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1252
extends OVMComplianceCheck {
    public Check_R_1252(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfNamedElement> topModules = LintUtils.getTopModulesCallingRunTest(this.fOVMProject);
        if (topModules == null || topModules.isEmpty()) {
            this.addHit(null, "There is no top module!");
            return;
        }
        for (RfNamedElement module : topModules) {
            if (module == null || !(module instanceof RfModule) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(module.getDeclaration().getParserPath(), this)) continue;
            module.visitHidObject(null, new ModuleVisitor((RfModule)module));
        }
    }

    private final class ModuleVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private RfModule module;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public ModuleVisitor(RfModule module) {
            this.module = module;
        }

        public boolean visit(IHidObject hidObject) {
            Check_R_1252.this.notifyCheckAlive();
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)hidObject;
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            return this.checkSetCall(hid);
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        private boolean checkSetCall(RfHid rfHid) {
            if (!"uvm_pkg::uvm_config_db.set".equals(LintUtils.getHidFullName((IHid)rfHid))) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    IHidObject value;
                    RfField configField;
                    IRfNamedElement key = (IRfNamedElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("inst_name") || (value = (IHidObject)entry.getValue()) != null && value instanceof RfHidImplicit && ((RfHidImplicit)value).isStringLiteral() && "\"uvm_test_top\"".equals(((RfHidImplicit)value).getName())) continue;
                    Check_R_1252.this.addHit(this.parserPath, rfHid, "Function 'uvm_pkg::uvm_config_db.set' in top module " + LintUtils.getNamedElementFullName(this.module) + " must be called with \"uvm_test_top\" as scope!");
                }
            }
            return true;
        }
    }
}

