/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1253")
@CheckName(value="R.1253")
@CheckLabel(labels={RuleLabel.DELAY, RuleLabel.DRIVER, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use variable delays in drivers")
@CheckDescription(value="If a driver needs to insert variable delays within or between transactions when driving the pins of an interface, this should be handled by storing delays in the transaction passed to the driver and not inside the driver itself.\n\nExamples:\n\nclass my_driver extends uvm_driver;\n[...]\n    #delay;          // not allowed\n\t  #10ns;           // not allowed iff checkLiteralDelays is true\n[...]\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1253
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, delays with literal values are also checked.", name="checkLiteralDelays", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckLiteralDelays;
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);

    public Check_R_1253(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmDriver == null) {
            return;
        }
        Set<RfClass> allDrivers = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmDriver);
        if (allDrivers.isEmpty()) {
            return;
        }
        for (RfClass driver : allDrivers) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(driver.getDeclaration().getParserPath(), this)) {
                return;
            }
            driver.visitHidObject(null, new IHidVisitor<IHidOperator>(){
                private ParserPath parserPath;

                public boolean visit(IHidOperator hidOperator) {
                    if (!(hidOperator instanceof RfHidOperator)) {
                        return true;
                    }
                    RfHidOperator operator = (RfHidOperator)hidOperator;
                    if (!operator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                        return true;
                    }
                    Check_R_1253.this.notifyCheckAlive();
                    Set hids = hidOperator.getLHHids(HID_FLATTENING);
                    for (IHid hid : hids) {
                        if (hid instanceof RfHid && ((RfHid)hid).getElement() instanceof RfField) {
                            Check_R_1253.this.addHit(this.parserPath, (RfHid)hid, "Delay with variable '" + HidUtils.toNiceString((IHidObject)hid) + "' is used!");
                            return true;
                        }
                        if (!Check_R_1253.this.pCheckLiteralDelays || !(hid instanceof RfHidImplicit)) continue;
                        Check_R_1253.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Delay with value '" + HidUtils.toNiceString((IHidObject)hid) + "' is used!");
                        return true;
                    }
                    return true;
                }

                public void setParserPath(ParserPath parserPath) {
                    this.parserPath = parserPath;
                }

                public Class<IHidOperator> getType() {
                    return IHidOperator.class;
                }
            });
        }
    }
}

