/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1254")
@CheckName(value="R.1254")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.SEQUENCE_ITEM, RuleLabel.AGENT, RuleLabel.COMPONENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Declare one sequence item for each agent")
@CheckDescription(value="Declaring multiple sequence items of different type inside an agent is not recommended, a single one should used to increase the clarity of the code.\nThe rule will search for the sequence items in the agent's fields and in its components (monitor, driver and sequencer), if present.\n\nExamples:\n\nclass my_agent extends xvm_agent; // allowed\n  my_seqence_item item;\nendclass\n\nclass my_agent2 extends xvm_agent; // not allowed\n  my_seqence_item item1;\n  my_seqence_item2 item2;\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1254
extends OVMComplianceCheck {
    public Check_R_1254(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequenceItem == null || this.fOVMProject.fOvmAgent == null || this.fOVMProject.fOvmDriver == null || this.fOVMProject.fOvmMonitor == null || this.fOVMProject.fOvmSequencer == null) {
            return;
        }
        Set<RfClass> agents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmAgent);
        for (RfClass agent : agents) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(agent.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> allFields = agent.getLocalFields();
            HashSet<RfClass> sequenceItems = new HashSet<RfClass>();
            RfClass agentMonitor = null;
            RfClass agentDriver = null;
            RfClass agentSequencer = null;
            if (allFields == null || allFields.isEmpty()) {
                this.addHit(agent, "No sequence item declared inside '" + LintUtils.getNamedElementFullName(agent) + "' agent or its agent fields!");
                continue;
            }
            for (RfField field : allFields) {
                RfClass classType;
                if (!field.isField() || (classType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null) continue;
                if (LintUtils.isSubClassOf(classType, this.fOVMProject.fOvmSequenceItem)) {
                    sequenceItems.add(classType);
                    continue;
                }
                if (LintUtils.isSubClassOf(classType, this.fOVMProject.fOvmDriver)) {
                    agentDriver = classType;
                    continue;
                }
                if (LintUtils.isSubClassOf(classType, this.fOVMProject.fOvmMonitor)) {
                    agentMonitor = classType;
                    continue;
                }
                if (!LintUtils.isSubClassOf(classType, this.fOVMProject.fOvmSequencer)) continue;
                agentSequencer = classType;
            }
            if (sequenceItems.size() < 2) {
                this.getSequenceItemsFromField(sequenceItems, agentMonitor);
                this.getSequenceItemsFromField(sequenceItems, agentDriver);
                this.getSequenceItemsFromField(sequenceItems, agentSequencer);
            }
            if (sequenceItems.isEmpty()) {
                this.addHit(agent, "No sequence item declared inside '" + LintUtils.getNamedElementFullName(agent) + "' agent or its agent fields!");
                continue;
            }
            if (sequenceItems.size() <= 1) continue;
            this.addHit(agent, "Multiple sequence items declared inside '" + LintUtils.getNamedElementFullName(agent) + "' agent or its agent fields!");
        }
    }

    private void getSequenceItemsFromField(Set<RfClass> sequenceItems, RfClass agentField) {
        if (agentField == null) {
            return;
        }
        List<RfField> fields = agentField.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field, RfTypesResolver.create((IRfScopeElement)agentField, agentField.getRfProject(), 6));
            if (fieldType == null || !LintUtils.isSubClassOf(fieldType, this.fOVMProject.fOvmSequenceItem)) continue;
            sequenceItems.add(fieldType);
        }
    }
}

