/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1255")
@CheckName(value="R.1255")
@CheckLabel(labels={RuleLabel.MONITOR, RuleLabel.COMPONENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="A monitor shall never rely on information collected from other components")
@CheckDescription(value="If a monitor relies on information from other components, it's reusability decreases. Also if the components have an incorrect behavior, that may propagate into malfunctioning of the monitors.\nThis rule enforces that no component fields, nor any ports/exports or implementations should be found in a monitor. The only exception to this rule being the xvm analysis ports.\n\nExamples:\n\nclass my_monitor extends xvm_monitor;\n\txvm_get_port#() pt\t\t\t\t\t\t\t// not allowed\n\txvm_analysis_port#() analysis_pt;\t\t\t// allowed\n\txvm_master_export exp;\t\t\t\t\t\t// not allowed\n\txvm_slave_imp impl;\t\t\t\t\t\t\t// not allowed\n\tmy_scoreboard scb;\t\t\t\t\t\t\t// not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1255
extends OVMComplianceCheck {
    public Check_R_1255(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass monitorClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_monitor"), true);
        RfClass componentClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component"), true);
        RfClass portBaseClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base"), true);
        RfClass analysisPortClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port"), true);
        if (monitorClass == null || componentClass == null) {
            return;
        }
        Set<RfClass> allMonitors = this.fOVMProject.getAllXVMSubClasses(monitorClass);
        if (allMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : allMonitors) {
            List<RfField> fields;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(monitor.getFile()) || (fields = monitor.getLocalFields()) == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                IRfNamedElement fieldType = LintUtils.getAssociatedFinalDataType(field).getAssocType();
                if (!(fieldType instanceof RfClass)) continue;
                if (LintUtils.isSubClassOf((RfClass)fieldType, componentClass)) {
                    this.addHit(field, "Component '" + field.getName() + "' declared inside monitor class '" + LintUtils.getNamedElementFullName(monitor) + "'!");
                }
                if (!LintUtils.isSubClassOf((RfClass)fieldType, portBaseClass) || LintUtils.isSubClassOf((RfClass)fieldType, analysisPortClass)) continue;
                this.addHit(field, "Port '" + field.getName() + "' declared inside monitor class '" + LintUtils.getNamedElementFullName(monitor) + "'!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

