/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.2.23")
@CheckID(value="R.1256")
@CheckName(value="R.1256")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ENVIRONMENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="When instantiating a component in the test bench environment use env instead of agent")
@CheckDescription(value="In the testbench class do not have any agent field.\n\nExamples:\n\nclass testbench_tb extends xvm_env;\n    xvm_agent my_agent;   // not allowed\n    xvm_env my_env;       // allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class Check_R_1256
extends AbstractNamePatternParametersCheck {
    private RfClass xvmAgentClass;

    public Check_R_1256(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String objectAgentName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_agent");
        this.xvmAgentClass = this.fOVMProject.getRfProject().getClass(objectAgentName, true);
        if (this.xvmAgentClass == null) {
            this.addHit(null, "Class '" + objectAgentName + "' not found!");
            return;
        }
        Collection<RfClass> values = this.getClassesWithPatterns("testbenchClassNamePattern").values();
        if (values == null || values.isEmpty()) {
            return;
        }
        for (RfClass clazz : values) {
            List<RfField> fields;
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this) || (fields = clazz.getFields()) == null || fields.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfField field : fields) {
                RfNamedElement associatedType;
                if (field == null || (associatedType = LintUtils.getAssociatedFinalType(field)) == null || !(associatedType instanceof RfClass) || !this.xvmAgentClass.equals(associatedType) && !LintUtils.isChildOf((RfClass)associatedType, this.xvmAgentClass)) continue;
                this.addHit(field, "Agent field '" + LintUtils.getNamedElementFullName(field) + "' declared inside testbench '" + LintUtils.getNamedElementFullName(clazz) + "'!");
            }
        }
    }
}

