/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1257")
@CheckName(value="R.1257")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.TASK, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="In the driver and monitor create a separate task for transaction read and write")
@CheckDescription(value="This rule checks that there are no sequence item access operations in the run phase of the driver/monitor.\nThe run phase in the driver and monitor shall deal with transactions get/set, reset handling or pipeline protocol handling.\nDetailed transaction collection shall be handled by a separate virtual task which can be easily overridden.\n\nExamples:\n\nclass my_monitor extends uvm_monitor;\n\tvirtual task run_phase(uvm_phase phase);\n\t\tseq_item.x = VALUE;\t\t\t\t\t\t// not allowed\n\t\tseq_item.foo();\t\t\t\t\t\t\t// not allowed\n      collect_transfers();\n\tendtask\n\n\tvirtual task collect_transfers();\n\t\tseq_item.x = VALUE;\t\t\t\t\t\t// allowed\n\t\tseq_item.foo();\t\t\t\t\t\t\t// allowed\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1257
extends OVMComplianceCheck {
    public Check_R_1257(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfClass> driversAndMonitors = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmDriver);
        driversAndMonitors.addAll(this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmMonitor));
        for (RfClass driverMonitor : driversAndMonitors) {
            RfFunction runPhase;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(driverMonitor.getFile()) || (runPhase = this.getRunPhase(driverMonitor)) == null) continue;
            runPhase.visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        }
    }

    private RfFunction getRunPhase(RfClass clazz) {
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        RfFunction runPhaseFunction = clazz.getLocalMember(RfFunction.class, xvmRunPhaseMethodName, false);
        if (runPhaseFunction == null) {
            return null;
        }
        return runPhaseFunction;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldClass == null) {
                return true;
            }
            if (LintUtils.isSubClassOf(fieldClass, ((Check_R_1257)Check_R_1257.this).fOVMProject.fOvmSequenceItem)) {
                Check_R_1257.this.addHit(this.parserPath, hid, "Forbidden access to the '" + HidUtils.toNiceString((IHidObject)hid) + "' sequence item in the run phase of a driver or a monitor!");
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

