/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1258")
@CheckName(value="R.1258")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.TOP_MODULE, RuleLabel.PORT})
@CheckTitle(value="Use one SystemVerilog interface instance per DUT interface")
@CheckDescription(value="This rule checks if there are more than one interface instance of the same type declared in the top module that is connected to the same DUT instance.\nModules that call run_test are considered top modules.\n\nExample:\n\nmodule top;\n  if1 vif1();\n  if1 diff_vif1();\n  if2 vif2();\n\n  dut u_dut (\n\t  .pif1             (vif1),\n\t  .pif1_2           (diff_vif1)      // not allowed\n  );\n\n  dut u_dut_fixed (\n\t  .pif1             (vif1),\n\t  .pif1_2           (vif1),          // allowed\n\t  .pif2             (vif2)           // also allowed\n  );\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1258
extends OVMComplianceCheck {
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);

    public Check_R_1258(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfNamedElement> topModules = LintUtils.getTopModulesCallingRunTest(this.fOVMProject);
        if (topModules == null || topModules.isEmpty()) {
            return;
        }
        for (RfNamedElement module : topModules) {
            ParserPath parserPath = module.getDeclaration().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            HashMap dummyPortMap = new HashMap();
            module.accept(null, element -> {
                this.notifyCheckAlive();
                if (!(element instanceof RfInstance)) {
                    return true;
                }
                RfInstance instance = (RfInstance)element;
                RfNamedElement instanceType = LintUtils.getAssociatedFinalType(instance);
                if (!(instanceType instanceof RfModule)) {
                    return true;
                }
                HashMap<RfNamedElement, HashSet<RfInstance>> intfInstancesMap = new HashMap<RfNamedElement, HashSet<RfInstance>>();
                Map ports = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance), (Map)dummyPortMap, HID_FLATTENING);
                if (ports == null || ports.isEmpty()) {
                    return true;
                }
                for (Map.Entry entry : ports.entrySet()) {
                    for (TCConnSignal signal : (Set)entry.getValue()) {
                        RfNamedElement connectionType;
                        RfInstance connectionInstance;
                        IRfNamedElement candidate = DesignUtils.resolveSignal((Object)signal.signal, (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance.getEnclosingScope()), null, (Map)dummyPortMap);
                        if (candidate instanceof HierarchicalElement) {
                            candidate = ((HierarchicalElement)candidate).getFirstSegment();
                        }
                        if (!(candidate instanceof RfInstance) || (connectionInstance = (RfInstance)candidate) == null || !module.equals(connectionInstance.getEnclosingScope()) || !((connectionType = LintUtils.getAssociatedFinalType(connectionInstance)) instanceof RfInterface)) continue;
                        HashSet<RfInstance> intfInstances = (HashSet<RfInstance>)intfInstancesMap.get(connectionType);
                        if (intfInstances == null) {
                            intfInstances = new HashSet<RfInstance>();
                        }
                        intfInstances.add(connectionInstance);
                        intfInstancesMap.put(connectionType, intfInstances);
                    }
                }
                if (intfInstancesMap.isEmpty()) {
                    return true;
                }
                for (Map.Entry entry : intfInstancesMap.entrySet()) {
                    if (((Set)entry.getValue()).size() <= 1) continue;
                    this.addHit(instance, "DUT '" + instance.getName() + "' is connected to more than one instance of interface type '" + ((RfNamedElement)entry.getKey()).getName() + "'!");
                }
                return true;
            });
        }
    }
}

