/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1259")
@CheckName(value="R.1259")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.AGENT, RuleLabel.METHOD, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the method get_is_active to determine if the agent is active or passive")
@CheckDescription(value="Do not use the method get_is_active to determine if the agent is used as active or passive component. Instead, get the is_active value from the configuration object.\n\nExamples:\n\nclass my_agent extends uvm_agent\n\tfunction void build_phase(uvm_phase phase);\n\t\tsuper.build_phase(phase);\n\n\t\tif (get_is_active() == UVM_ACTIVE) begin // not allowed\n\t\tend\n\t\tif (!uvm_config_db #(my_config)::get(this, \"\";, \"my_config\", m_config))\n\t\t\t`uvm_error(get_type_name(), \"Config object missing\")\n\t\tif (m_config.is_active() == UVM_ACTIVE) begin // allowed\n\t\tend\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1259
extends OVMComplianceCheck {
    String bannedMethodName = "uvm_pkg::uvm_agent.get_is_active";

    public Check_R_1259(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)element;
            if (Check_R_1259.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1259.this.notifyCheckAlive();
            String methodName = method.getFullName();
            if (methodName.equals(Check_R_1259.this.bannedMethodName)) {
                Check_R_1259.this.addHit(this.parserPath, hidObject, "Do not use the 'get_is_active' method, get instead the 'is_active' value from the configuration object!");
            }
            return true;
        }
    }
}

