/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1260")
@CheckName(value="R.1260")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.ENVIRONMENT, RuleLabel.REGISTER_MODEL, RuleLabel.FIELD, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Any environment that uses a register model should have a variable named regmodel")
@CheckDescription(value="In each class extending from uvm_env if there is a field of type extending from uvm_reg_block it should be named 'regmodel'.\n\nExamples:\n\nclass env_class extends uvm_env;\n    uvm_reg_block my_reg;     // not allowed\n    uvm_reg_block regmodel;   // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1260
extends OVMComplianceCheck {
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private RfClass uvmEnvClass;
    private RfClass uvmRegBlock;

    public Check_R_1260(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlock == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmEnvClass = this.fOVMProject.getRfProject().getClass(UVM_ENV, true);
        if (this.uvmEnvClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        Set<RfClass> allXVMSubClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmEnvClass);
        if (allXVMSubClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allXVMSubClasses) {
            List<RfField> fields;
            if (clazz == null) continue;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this) || (fields = clazz.getFields()) == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                RfClass associatedType;
                if (field == null || (associatedType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !LintUtils.isSubClassOf(associatedType, this.uvmRegBlock) || "regmodel".equals(field.getName())) continue;
                this.addHit(field, "Register block '" + LintUtils.getNamedElementFullName(field) + "' inside environment class must be named 'regmodel'!");
            }
        }
    }
}

