/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="24.1.12")
@CheckID(value="R.1262")
@CheckName(value="R.1262")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.INTERFACE, RuleLabel.COVERAGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Assertions and coverage collection must be done in interfaces")
@CheckDescription(value="The check verifies that concurrent assertions and cover properties are declared in interfaces.\nIt is easier to have assertions and properties in interfaces since such assertions are typically quite simple in themselves and relate directly to the behavior of the interface.\n\nExamples:\n\nmodule top;\n    assertion_name: assert property (...) // not allowed\n    cover_name: cover property (...) // not allowed\nendmodule\n\ninterface intf;\n    assertion_name: assert property (...) // allowed\n    cover_name: cover property (...) // allowed\nendinterface\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1262
extends OVMComplianceCheck {
    public Check_R_1262(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration == null) {
                return true;
            }
            this.notifyCheckAlive();
            if (this.checkPreWaivers(declaration.getParserPath())) {
                return true;
            }
            if (!(namedElement instanceof RfAssertExpect)) {
                return true;
            }
            RfAssertExpect assertExpect = (RfAssertExpect)namedElement;
            if (!assertExpect.isConcurrentCoverProperty() && !assertExpect.isConcurrentAssert()) {
                return true;
            }
            RfInterface scope = assertExpect.getEnclosingScope(RfInterface.class);
            if (scope == null) {
                String enclosingScope = "outside of interfaces";
                RfNamedElement typeContainer = assertExpect.getClosestTypeContainer();
                if (typeContainer != null) {
                    enclosingScope = "in " + LintUtils.getElementKind(typeContainer) + " '" + LintUtils.getNamedElementFullName(typeContainer) + "'";
                }
                this.addHit(assertExpect, String.valueOf(assertExpect.isConcurrentAssert() ? "Concurrent assert" : "Cover property") + (assertExpect.isAnonymous() ? " " : " '" + assertExpect.getName() + "' ") + "declared " + enclosingScope + "!");
            }
            return true;
        });
    }

    private boolean checkPreWaivers(ParserPath path) {
        if (path == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

