/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1263")
@CheckName(value="R.1263")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.AGENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Use a virtual sequence to coordinate the behavior of multiple agents")
@CheckDescription(value="If there are at least 2 agents then there must be a virtual sequence to coordinate the behavior of those agents.\n\nExamples:\n\nclass agent_class_1 extends xvm_agent;\nendclass\n\nclass agent_class_2 extends xvm_agent;\nendclass\n\nclass sequence_class extends xvm_sequence;   //allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1263
extends OVMComplianceCheck {
    private RfClass xvmSequenceBaseClass;
    private boolean isStarted;

    public Check_R_1263(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfClass> allSequences;
        String packageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        if (this.fOVMProject.fOvmAgent == null) {
            this.addHit(null, "Class '" + packageName + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_agent") + "' not found!");
            return;
        }
        if (this.fOVMProject.fOvmSequence == null) {
            this.addHit(null, "Class '" + packageName + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence") + "' not found!");
            return;
        }
        if (this.fOVMProject.fOvmSequenceItem == null) {
            this.addHit(null, "Class '" + packageName + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_item") + "' not found!");
            return;
        }
        if (this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmAgent).size() < 2) {
            return;
        }
        String xvmSequenceBaseClassString = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_base");
        this.xvmSequenceBaseClass = this.fOVMProject.getRfProject().getClass(xvmSequenceBaseClassString, true);
        if (this.xvmSequenceBaseClass == null) {
            this.xvmSequenceBaseClass = this.fOVMProject.fOvmSequence;
        }
        if ((allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence)).isEmpty()) {
            this.addHit(null, "There must be a virtual sequence defined when there are more than 2 agent classes!");
            return;
        }
        StartCallVisitor visitor = new StartCallVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        if (this.isStarted) {
            this.isStarted = false;
            return;
        }
        this.addHit(null, "There must be a virtual sequence started when there are more than 2 agent classes!");
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class StartCallVisitor
    extends RfHidVisitor {
        StartCallVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            if (Check_R_1263.this.isStarted) {
                return false;
            }
            Check_R_1263.this.notifyCheckAlive();
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            RfNamedElement scope = (RfNamedElement)((RfHidHolder)this.holder).getScope();
            if (scope == null || scope.getFile() == null || Check_R_1263.this.fOVMProject.isOVMFile(scope.getFile().getName())) {
                return true;
            }
            if (Check_R_1263.this.checkPreWaivers(scope.getFile())) {
                return true;
            }
            IRfNamedElement resolvedElement = rfHid.getElement();
            if (!(resolvedElement instanceof RfFunction)) {
                return true;
            }
            if (!"start".equals(resolvedElement.getName())) {
                return true;
            }
            Hid parentHid = rfHid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)parentElement;
            RfClass sequence = LintUtils.getFieldFinalClassTypeOrNull(field);
            IReparseInfo reparseInfo = rfHid.getReparseInfo();
            if (reparseInfo instanceof ReparseInfo && LintUtils.isSubClassOf(sequence, Check_R_1263.this.xvmSequenceBaseClass) && Check_R_1263.this.fOVMProject.isReparseStackInOVMFile((ReparseInfo)reparseInfo)) {
                RfNamedElement enclosingScope = scope.getEnclosingScope();
                RfHidHolder hidHolder = enclosingScope.getHidHolder();
                Map map = hidHolder.getHidObjectsMap();
                if (enclosingScope == null || hidHolder == null || map == null) {
                    return true;
                }
                block0: for (Map.Entry entry : map.entrySet()) {
                    ListContainer list = (ListContainer)entry.getValue();
                    if (list == null || list.isEmpty()) {
                        return true;
                    }
                    for (IHidObject hidObject : list) {
                        List methodCalls;
                        RfHid rfHidObject;
                        if (!(hidObject instanceof RfHid) || !"$cast".equals((rfHidObject = (RfHid)hidObject).getName()) || (methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHidObject)) == null || methodCalls.isEmpty()) continue;
                        for (MethodCall methodCall : methodCalls) {
                            if (methodCall.argumentValuesMapRaw == null) continue;
                            for (Map.Entry argumentsEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                                RfHid valueHid;
                                IRfNamedElement argument = (IRfNamedElement)argumentsEntry.getKey();
                                IHidObject argumentValue = (IHidObject)argumentsEntry.getValue();
                                if (!"source_exp".equals(argument.getName())) continue;
                                if (!(argumentValue instanceof RfHid) || !((valueHid = (RfHid)argumentValue).getElement() instanceof RfField)) continue block0;
                                field = (RfField)valueHid.getElement();
                                sequence = LintUtils.getFieldFinalClassTypeOrNull(field);
                                continue block0;
                            }
                            continue block0;
                        }
                        continue block0;
                    }
                }
            }
            if (sequence != null && LintUtils.isVirtualSequence(sequence, ((Check_R_1263)Check_R_1263.this).fOVMProject.fOvmSequence, ((Check_R_1263)Check_R_1263.this).fOVMProject.fOvmSequenceItem)) {
                Check_R_1263.this.isStarted = true;
            }
            return true;
        }
    }
}

