/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1265")
@CheckName(value="R.1265")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.TYPEDEF, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use typedef uvm_path_e")
@CheckDescription(value="Typedef uvm_path_e has been renamed to uvm_door_e in the UVM IEEE 1800.2-2020 standard and library implementation.\nThe rule will fail for usages of UVM_DEFAULT_PATH enum items as well, since it was replaced with UVM_DEFAULT_DOOR.\n\nCheck supports pre-waiving.")
public class Check_R_1265
extends OVMComplianceCheck {
    private static final String UVM_PATH_E = "uvm_pkg::uvm_path_e";
    private static final String UVM_DEFAULT_PATH = "UVM_DEFAULT_PATH";

    public Check_R_1265(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!(namedElement instanceof RfAssociatedType)) {
                return true;
            }
            if (namedElement.getDeclaration() != null && this.checkPrewaivers(namedElement.getDeclaration().getParserPath())) {
                return true;
            }
            this.notifyCheckAlive();
            IRfNamedElement type = ((RfAssociatedType)namedElement).getAssociatedTypeNoLastLevelParams();
            if (type instanceof RfListType) {
                type = ((RfListType)type).getAssociatedBaseType();
            }
            if (!(type instanceof RfTypeAlias)) {
                return true;
            }
            if (!UVM_PATH_E.equals(type.getQualifiedName())) {
                return true;
            }
            this.addHit(namedElement, "Banned typedef '" + type.getName() + "'!");
            return true;
        });
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_R_1265.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1265.this.notifyCheckAlive();
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfField)) {
                    return true;
                }
                RfField elementField = (RfField)element;
                if (!elementField.isEnumElement()) {
                    return true;
                }
                RfNamedElement fieldScope = elementField.getEnclosingScope();
                if (!(fieldScope instanceof RfStruct) && ((RfStruct)fieldScope).isEnum()) {
                    return true;
                }
                if (!Check_R_1265.UVM_PATH_E.equals("uvm_pkg::" + ((RfStruct)fieldScope).getAliasName())) {
                    return true;
                }
                if (!Check_R_1265.UVM_DEFAULT_PATH.equals(elementField.getName())) {
                    return true;
                }
                Check_R_1265.this.addHit(this.parserPath, hidObject, "Banned enum item '" + elementField.getName() + "'!");
                return true;
            }
        });
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

