/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1266")
@CheckName(value="R.1266")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.CLASS, RuleLabel.PACKAGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Covergroups must be declared either in classes or packages")
@CheckDescription(value="Either place the declaration of a covergroup in a class or in a package.\nThe embedded covergroup is the most straightforward way to use a covergroup in a class.\nHowever several classes can reuse the same covergroup by placing the covergroup declaration in a package outside of any class and having the classes instantiate the covergroup with appropriate parameters.\n\nExamples:\n\nclass test_class;\n    covergroup covergroup_test @ (posedge clk);  // allowed\n    endgroup\nendclass\n\nmodule test_module;\n    covergroup covergroup_test @ (posedge clk);  // not allowed\n    endgroup\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1266
extends OVMComplianceCheck {
    public Check_R_1266(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        block0: for (RfNamedElement coverGroup : this.fOVMProject.getAllCovergroups()) {
            if (coverGroup == null || !(coverGroup instanceof RfCovergroup) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(coverGroup.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            RfNamedElement enclosingScope = coverGroup.getEnclosingScope();
            while (enclosingScope != null) {
                if (enclosingScope instanceof RfClass || enclosingScope instanceof RfPackage) continue block0;
                if (enclosingScope instanceof RfProgram || enclosingScope instanceof RfModule || enclosingScope instanceof RfInterface || enclosingScope instanceof RfLibrary) {
                    this.addHit(coverGroup, "Covergroup '" + LintUtils.getNamedElementFullName(coverGroup) + "' should be defined inside classes or packages!");
                }
                enclosingScope = enclosingScope.getEnclosingScope();
            }
            this.addHit(coverGroup, "Covergroup '" + LintUtils.getNamedElementFullName(coverGroup) + "' should be defined inside classes or packages!");
        }
    }
}

