/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1267")
@CheckName(value="R.1267")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.CONFIG_DB, RuleLabel.TEST, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Configuration database \"set\" operations should be done only in tests and virtual sequences")
@CheckDescription(value="The test component shall be used to define which sequence to run, and defines the configuration and parameters to customize the environment.\nDo not call 'uvm_config_db::set' in other components except for tests and virtual sequences.\n\nExamples:\n\nclass my_test1 extends uvm_test;\n\tvirtual function void build_phase(uvm_phase phase);\n\t\tsuper.build_phase(phase);\n\t\tuvm_config_db#(example_config)::set(this, \"\", \"cfg\", value); // allowed\n\tendfunction\nendclass\n\nclass my_env extends uvm_env;\n\tvirtual function void build_phase(uvm_phase phase);\n\t\tsuper.build_phase(phase);\n\t\tuvm_config_db#(example_config)::set(this, \"\", \"cfg\", value); // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1267
extends OVMComplianceCheck {
    private static final String BANNED_METHOD_NAME = "uvm_pkg::uvm_config_db.set";

    public Check_R_1267(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null || this.fOVMProject.fOvmTest == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)element;
            if (Check_R_1267.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1267.this.notifyCheckAlive();
            String methodName = method.getFullName();
            if (!methodName.equals(Check_R_1267.BANNED_METHOD_NAME)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            RfClass enclosingClass = (RfClass)holderScope.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) {
                return true;
            }
            if (!LintUtils.isSubClassOf(enclosingClass, ((Check_R_1267)Check_R_1267.this).fOVMProject.fOvmComponent)) {
                return true;
            }
            if (!LintUtils.isSubClassOf(enclosingClass, ((Check_R_1267)Check_R_1267.this).fOVMProject.fOvmTest) && !LintUtils.isVirtualSequence(enclosingClass, ((Check_R_1267)Check_R_1267.this).fOVMProject.fOvmSequence, ((Check_R_1267)Check_R_1267.this).fOVMProject.fOvmSequenceItem)) {
                Check_R_1267.this.addHit(this.parserPath, hidObject, "'uvm_config_db::set' called in component:'" + LintUtils.getNamedElementFullName(enclosingClass) + "' which is not a test nor a virtual sequence!");
            }
            return true;
        }
    }
}

