/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1268")
@CheckName(value="R.1268")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.REGISTER_BLOCK, RuleLabel.ENVIRONMENT, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="There should be a single top-level register block that instantiates the register blocks associated with the child environments")
@CheckDescription(value="In each environment class there must be only one uvm_reg_block object instantiated.\n\nExamples:\n\nclass env_class extends uvm_env;  //not allowed\n  reg_block_class regmodel1;\n  reg_block_class regmodel2;\n\n  function build();\n    regmodel1 = new();   // allowed\n    regmodel2 = reg_model_class::type_id::create(\"test\", null, \"name_test\");  // allowed\n  endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1268
extends OVMComplianceCheck {
    private static final String UVM_OBJECT_REGISTRY_CREATE = "uvm_pkg::uvm_object_registry.create";
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private RfClass uvmEnvClass;
    private RfClass uvmRegBlock;

    public Check_R_1268(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlock == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmEnvClass = this.fOVMProject.getRfProject().getClass(UVM_ENV, true);
        if (this.uvmEnvClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        Set<RfClass> allXVMSubClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmEnvClass);
        if (allXVMSubClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allXVMSubClasses) {
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            RegModelInstantiationVisitor visitor = new RegModelInstantiationVisitor();
            clazz.visitHidObject(null, (IHidVisitor<?>)visitor);
            if (visitor.getRegModelInstantiation() <= 1) continue;
            this.addHit(clazz, "Environment class '" + LintUtils.getNamedElementFullName(clazz) + "' has more than one reg model instantiated!");
        }
    }

    private class RegModelInstantiationVisitor
    extends HidOperatorVisitor {
        private int hasRegModelInstantiation;

        public RegModelInstantiationVisitor() {
            super(null);
            this.hasRegModelInstantiation = 0;
        }

        public boolean visit(HidOperator operator) {
            RfClass lhType;
            if (!operator.isAssignment()) {
                return true;
            }
            Check_R_1268.this.notifyCheckAlive();
            IHidObject lhValue = operator.getLHValue();
            ListContainer rhValues = operator.getRHValues();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement lhElement = lhHid.getElement();
            if (lhElement instanceof RfField && ((lhType = LintUtils.getFieldFinalClassTypeOrNull((RfField)lhElement)) == null || !LintUtils.isSubClassOf(lhType, Check_R_1268.this.uvmRegBlock))) {
                return true;
            }
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs rhHidAccessArgs = (RfHidAccessArgs)((Object)rhValues.get(0));
            Hid rhHid = rhHidAccessArgs.getParentHid();
            if (!(rhHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement rhElement = rhHid.getElement();
            if (!(rhElement instanceof RfFunction)) {
                return true;
            }
            RfFunction rhFunction = (RfFunction)rhElement;
            if (!rhFunction.isConstructor() && !Check_R_1268.UVM_OBJECT_REGISTRY_CREATE.equals(rhFunction.getFullName())) {
                return true;
            }
            ++this.hasRegModelInstantiation;
            return this.hasRegModelInstantiation <= 1;
        }

        public int getRegModelInstantiation() {
            return this.hasRegModelInstantiation;
        }
    }
}

