/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfParamsHolder;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1269")
@CheckName(value="R.1269")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Group the configuration parameters into a configuration object")
@CheckDescription(value="Using a configuration object provides a single place where you expect to find the configuration parameters and allows all the configuration parameters to be randomized with a single call.\nThis rule checks the type parameter of uvm_config_db::get/set calls. It fails if it is not a class or a virtual interface.\n\nExamples:\n\nclass my_env extends uvm_env;\n\n  my_env_config m_config;\n\n  function void build_phase(uvm_phase phase);\n    uvm_config_db #(int)::set(this, \"\", \"\", null); // not allowed\n    uvm_config_db #(my_env_config)::set(this, \"\", \"\", null); // allowed\n  endfunction\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1269
extends OVMComplianceCheck {
    Set<String> checkedMethods = new HashSet<String>();

    public Check_R_1269(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkedMethods.clear();
        this.checkedMethods.add("uvm_pkg::uvm_config_db.set");
        this.checkedMethods.add("uvm_pkg::uvm_config_db.get");
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null || this.scope == null) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null || Check_R_1269.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)element;
            if (Check_R_1269.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1269.this.notifyCheckAlive();
            String methodName = method.getFullName();
            if (!Check_R_1269.this.checkedMethods.contains(methodName)) {
                return true;
            }
            RfProject rfProject = this.scope.getRfProject();
            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 0);
            resolver.resolveHidInContext((IHidObject)hidObject, ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)method, null, (boolean)true, (ELManager)rfProject.getELManager()), false);
            RfNamedElement configDb = resolver.getSpecializedElementScope(method.getEnclosingScope());
            if (!(configDb instanceof RfSpecializedClass)) {
                return true;
            }
            Map<String, IELParamValue> parameters = ((RfSpecializedClass)configDb).getLocalElabConstantValues();
            if (parameters == null || parameters.size() != 1) {
                return true;
            }
            IELParamValue parameter = parameters.get("T");
            if (parameter == null) {
                return true;
            }
            IRfNamedElement parameterElement = parameter.getNamedElement();
            if (parameterElement == null) {
                return true;
            }
            if (!(parameterElement instanceof RfClass) && !(parameterElement instanceof RfParamsHolder)) {
                Check_R_1269.this.addHit(this.parserPath, hidObject, "Configuration database call for " + parameterElement.getName() + " type should be grouped into a configuration object!");
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

