/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1270")
@CheckName(value="R.1270")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.EXTEND, RuleLabel.CLASS, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="Do not extend uvm_factory and uvm_report_server abstract classes")
@CheckDescription(value="The uvm_factory and uvm_report_server classes are abstract since version 1.2 of the UVM library, extending them directly could break the code.\nInstead, extending the uvm_default_factory and uvm_default_report_server is allowed.\n\nExamples:\nclass my_factory extends uvm_factory; // not allowed\nendclass\n\nclass my_factory extends uvm_default_factory; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1270
extends OVMComplianceCheck {
    private static final String UVM_FACTORY = "uvm_pkg::uvm_factory";
    private static final String UVM_REPORT_SERVER = "uvm_pkg::uvm_report_server";

    public Check_R_1270(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass uvmFactoryClass = this.fOVMProject.getRfProject().getClass(UVM_FACTORY, true);
        RfClass uvmReportServerClass = this.fOVMProject.getRfProject().getClass(UVM_REPORT_SERVER, true);
        if (uvmFactoryClass == null || uvmReportServerClass == null) {
            return;
        }
        this.checkChildren(uvmFactoryClass);
        this.checkChildren(uvmReportServerClass);
    }

    private void checkChildren(RfClass clazz) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            if (this.fOVMProject.isOVMElement(child) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(child.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            this.addHit(child, "Extending abstract class '" + clazz.getName() + "' by '" + LintUtils.getNamedElementFullName(child) + "' is not allowed!");
        }
    }
}

