/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1271")
@CheckName(value="R.1271")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the UVM resource database")
@CheckDescription(value="Using the resource database is not recommended since the scope, an arbitrary chosen string, must match for the set() and get() calls.\nInstead, using the configuration database is recommended for better code quality and modularity because it requires a verification context argument, not just an string value.\n\nExamples:\nuvm_resource_db#(my_config)::set(\"my_component\", \"cfg\", cfg);     // not allowed\nuvm_config_db#(my_config)::set(this, \"my_component\", \"cfg\", cfg); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1271
extends OVMComplianceCheck {
    private static final String UVM_RESOURCE_GET_BY_NAME = "uvm_pkg::uvm_resource_db.get_by_name";
    private static final String UVM_RESOURCE_GET_BY_TYPE = "uvm_pkg::uvm_resource_db.get_by_type";
    private static final String UVM_RESOURCE_SET = "uvm_pkg::uvm_resource_db.set";

    public Check_R_1271(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1271.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1271.this.notifyCheckAlive();
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                String functionFullName = LintUtils.getNamedElementFullName(function);
                if (!(Check_R_1271.UVM_RESOURCE_GET_BY_NAME.equals(functionFullName) || Check_R_1271.UVM_RESOURCE_GET_BY_TYPE.equals(functionFullName) || Check_R_1271.UVM_RESOURCE_SET.equals(functionFullName))) {
                    return true;
                }
                Check_R_1271.this.addHit(this.parserPath, rfHid, "Forbidden '" + functionFullName + "' method call!");
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

