/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1272")
@CheckName(value="R.1272")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual sequences class names should match a naming pattern")
@CheckDescription(value="Having a naming pattern for virtual sequences makes it easier to distinguish such sequences from other sequences.\nA virtual sequence is a sequence that extends xvm_sequence with the default parameter value (xvm_sequence_item).\n\nExamples when namePattern is '.*_vseq':\n\nclass foo_vseq extends xvm_sequence; // allowed\nendclass\n\nclass foo extends xvm_sequence; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1272
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_vseq", description="All virtual sequences must match this pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePattern;
    private RfClass defaultParameterClass;

    public Check_R_1272(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.defaultParameterClass = this.fOVMProject.fOvmSequenceItem;
        if (this.defaultParameterClass == null) {
            return;
        }
        RfClass sequenceClass = this.fOVMProject.fOvmSequence;
        if (sequenceClass == null) {
            return;
        }
        Set<RfClass> allClasses = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        for (RfClass sequence : allClasses) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile())) continue;
            Matcher m = this.pNamePattern.matcher(sequence.getName());
            if (!LintUtils.isVirtualSequence(sequence, sequenceClass, this.defaultParameterClass) || m.matches()) continue;
            this.addHit(sequence, "Virtual sequence '" + LintUtils.getNamedElementFullName(sequence) + "' does not match the '" + this.pNamePattern.toString() + "' naming pattern!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

