/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1273")
@CheckName(value="R.1273")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.ENVIRONMENT, RuleLabel.REGISTER_BLOCK, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="The class name and the UVM instance name of each child register block should correspond to the name of the associated environment")
@CheckDescription(value="This rule checks that:\n1. register blocks inside environments have the name of the register block class begin with the prefix of the environment.\n2. sub register blocks inside top register block classes have the variable name and the UVM instance name begin with the prefix of the corresponding environment.\n\n\nExamples with envSuffix = '_env':\n\nclass test_env extends uvm_env;\n    reg_block_class regmodel1;      \t// not allowed\n    test_reg_block_class regmodel2;   // allowed\nendclass\n\nclass reg_block_class extends uvm_reg_block;\n\t  test_reg_block_class regblock;\t\t// not allowed\n\t  test_reg_block_class test_regblock;\t// allowed\n\n        function void build();\n            test_regblock = new(\"reg\");\t\t\t\t// not allowed\n            test_regblock = new(\"test_regblock\");\t// allowed\n        endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1273
extends OVMComplianceCheck {
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_OBJECT_REGISTRY = "uvm_pkg::uvm_object_registry";
    @CheckParameter(defaultValue="_env", description="Suffix of environment class names.", name="envSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pEnvSuffix;
    private RfClass uvmEnvClass;
    private RfClass uvmRegBlockClass;
    private RfClass uvmObjectRegistry;
    private RfFunction objRegistryCreateMethod;
    private Map<RfClass, String> regBlockToPrefix;

    public Check_R_1273(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass associatedType;
        this.uvmEnvClass = this.fOVMProject.getRfProject().getClass(UVM_ENV, true);
        if (this.uvmEnvClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        this.uvmRegBlockClass = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlockClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmObjectRegistry = this.fOVMProject.getRfProject().getClass(UVM_OBJECT_REGISTRY, true);
        if (this.uvmObjectRegistry == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_object_registry' not found!");
            return;
        }
        this.objRegistryCreateMethod = this.uvmObjectRegistry.getFunctionWithPrefix("create", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        this.regBlockToPrefix = new HashMap<RfClass, String>();
        Set<RfClass> allEnvSubClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmEnvClass);
        if (allEnvSubClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allEnvSubClasses) {
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            String className = clazz.getName();
            if (!className.endsWith(this.pEnvSuffix) || className.length() <= this.pEnvSuffix.length()) continue;
            String prefix = className.substring(0, className.length() - this.pEnvSuffix.length());
            List<RfField> fields = clazz.getFields();
            if (fields == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                if (field == null || (associatedType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !LintUtils.isSubClassOf(associatedType, this.uvmRegBlockClass)) continue;
                if (prefix != null && !associatedType.getName().startsWith(prefix)) {
                    this.addHit(field, "Register block type name '" + LintUtils.getNamedElementFullName(associatedType) + "' does not start with '" + prefix + "' prefix!");
                    continue;
                }
                this.regBlockToPrefix.put(associatedType, prefix);
            }
        }
        Set<RfClass> allRegBlockSubClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmRegBlockClass);
        if (allRegBlockSubClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allRegBlockSubClasses) {
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> fields = clazz.getFields();
            if (fields == null || fields.isEmpty()) continue;
            final HashMap<RfField, RfClass> currentFields = new HashMap<RfField, RfClass>();
            for (RfField field : fields) {
                if (field == null || (associatedType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !LintUtils.isSubClassOf(associatedType, this.uvmRegBlockClass) || !this.regBlockToPrefix.containsKey(associatedType)) continue;
                String prefix = this.regBlockToPrefix.get(associatedType);
                if (!field.getName().startsWith(prefix)) {
                    this.addHit(field, "Register block field name '" + LintUtils.getNamedElementFullName(field) + "' does not start with '" + prefix + "' prefix!");
                    continue;
                }
                currentFields.put(field, associatedType);
            }
            clazz.visitHidObject(null, new IHidVisitor<IHidOperator>(){
                private ParserPath parserPath;

                public boolean visit(IHidOperator hidOperator) {
                    if (!(hidOperator instanceof RfHidOperator)) {
                        return true;
                    }
                    RfHidOperator operator = (RfHidOperator)hidOperator;
                    if (!operator.isAssignment()) {
                        return true;
                    }
                    IHidObject lhHidObject = operator.getLHValue();
                    if (lhHidObject == null || !(lhHidObject instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement lhElem = ((RfHid)lhHidObject).getElement();
                    if (!(lhElem instanceof RfField) || !currentFields.containsKey(lhElem)) {
                        return true;
                    }
                    IHidObject firstRhValue = operator.getFirstRHValue();
                    if (firstRhValue == null || !(firstRhValue instanceof RfHidAccessArgs)) {
                        return true;
                    }
                    Hid rhParent = ((RfHidAccessArgs)firstRhValue).getParentHid();
                    if (rhParent == null || !(rhParent instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement rhParentElem = rhParent.getElement();
                    if (rhParentElem == null || !(rhParentElem instanceof RfFunction)) {
                        return true;
                    }
                    RfClass associatedType = (RfClass)currentFields.get(lhElem);
                    if (associatedType == null) {
                        return true;
                    }
                    RfFunction regBlockClassNewMethod = associatedType.getLocalFunction("new");
                    if (!rhParentElem.equals(Check_R_1273.this.objRegistryCreateMethod) && !rhParentElem.equals(regBlockClassNewMethod)) {
                        return true;
                    }
                    List<? extends IHidObject> args = ((RfHidAccessArgs)firstRhValue).getArgumentValues();
                    if (args == null || args.isEmpty()) {
                        return true;
                    }
                    for (IHidObject iHidObject : args) {
                        IHidObject nameArg;
                        IRfNamedElement argVar;
                        ISDataAbstract type;
                        if (!(iHidObject instanceof RfHidOperator) || !((type = ((RfHidOperator)iHidObject).getOperatorResolvedType()) instanceof SDataVariable) || !((argVar = ((SDataVariable)type).getVariable()) instanceof RfField) || !argVar.getName().equals("name") || (nameArg = ((RfHidOperator)iHidObject).getFirstRHValue()) == null || !(nameArg instanceof RfHidImplicit)) continue;
                        String prefix = Check_R_1273.this.regBlockToPrefix.get(associatedType);
                        String argNameString = ((RfHidImplicit)nameArg).getName();
                        argNameString = argNameString.substring(1, argNameString.length() - 1);
                        if (((RfHidImplicit)nameArg).isUnconnectedAssociation()) {
                            argNameString = ((RfField)argVar).getInitialValue(false);
                        }
                        if (argNameString.startsWith(prefix)) continue;
                        Check_R_1273.this.addHit(this.parserPath, (HidOccurrence)((RfHidOperator)hidOperator).getOccurrence(), "Register block instance name '" + (argNameString.isEmpty() ? "\"\"" : argNameString) + "' does not start with '" + prefix + "' prefix!");
                    }
                    return true;
                }

                public Class<IHidOperator> getType() {
                    return IHidOperator.class;
                }

                public void setParserPath(ParserPath parserPath) {
                    this.parserPath = parserPath;
                }
            });
        }
    }
}

