/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1274")
@CheckName(value="R.1274")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.CLASS_INSTANTIATION, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Only instantiate sequence items from sequences")
@CheckDescription(value="Classes that do not inherit from xvm_sequence are checked for sequence items instantiations.\nThis check flags any sequence items instantiations using 'create' or 'new' in a non-sequence class.\n\nExamples:\n\nclass my_class;\n\txvm_sequence_item seq_item;\n\ttask body();\n\t\tseq_item = xvm_sequence_item::type_id::create();  // not allowed\n\tendtask\nendclass\n\nclass my_class extends xvm_sequence;\n\txvm_sequence_item seq_item;\n\ttask body();\n\t\tseq_item = xvm_sequence_item::type_id::create();  // allowed\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1274
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="xvm_pkg::xvm_monitor", description="Comma separated list of full names of classes for which the extending classes should be skipped.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipBaseClasses;

    public Check_R_1274(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass sequenceClass = this.fOVMProject.fOvmSequence;
        RfClass sequenceItemClass = this.fOVMProject.fOvmSequenceItem;
        if (sequenceItemClass == null || sequenceClass == null) {
            return;
        }
        HashSet<RfClass> classesToSkip = new HashSet<RfClass>();
        classesToSkip.add(sequenceClass);
        for (String className : this.pSkipBaseClasses) {
            RfClass clazz = this.fOVMProject.getRfProject().getClass(className, true);
            if (clazz == null) continue;
            classesToSkip.add(clazz);
        }
        AssignmentVisitor visitor = new AssignmentVisitor(this.fOVMProject, sequenceClass, sequenceItemClass, classesToSkip);
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private RfNamedElement scope;
        private RfClass sequenceClass;
        private RfClass sequenceItemClass;
        private Set<RfClass> classesToSkip;
        private OVMProject proj;
        private ParserPath parserPath;

        public AssignmentVisitor(OVMProject fOVMProject, RfClass sequenceClass, RfClass sequenceItemClass, Set<RfClass> classesToSkip) {
            this.proj = fOVMProject;
            this.sequenceClass = sequenceClass;
            this.sequenceItemClass = sequenceItemClass;
            this.classesToSkip = classesToSkip;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            Check_R_1274.this.notifyCheckAlive();
            if (Check_R_1274.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (this.proj.isOVMFile(file.getName())) {
                return true;
            }
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rightHid = (IHidObject)rhValues.get(0);
            List<MethodCall> methodCalls = this.getMethodCall(rightHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                    return true;
                }
                if (!methodCall.method.getName().equals("new") && !((RfFunction)methodCall.method).getFullName().equals(String.valueOf(OVMUtils.prependLibraryPrefixTo(Check_R_1274.this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(Check_R_1274.this.fOVMProject.getLibraryKind(), "_object_registry.create"))) {
                    return true;
                }
                IHidObject lhValue = hidObject.getLHValue();
                if (lhValue instanceof RfHidAccess) {
                    lhValue = ((RfHidAccess)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid rfHid = (RfHid)lhValue;
                RfField sequenceItem = this.getSequenceItemOrNull(rfHid);
                if (sequenceItem == null) {
                    return true;
                }
                RfClass clazz = this.getCurrentNonSequenceClassOrNull(this.scope, this.classesToSkip);
                if (clazz == null) {
                    return true;
                }
                Check_R_1274.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Sequence item '" + sequenceItem.getName() + "' instantiated in a non-sequence class: '" + LintUtils.getNamedElementFullName(clazz) + "'!");
            }
            return true;
        }

        private RfClass getCurrentNonSequenceClassOrNull(RfNamedElement scope, Set<RfClass> classesToSkip) {
            RfClass clazz = scope.getEnclosingScope(RfClass.class);
            if (clazz == null) {
                return null;
            }
            if (LintUtils.isSubClassOfAny(clazz, classesToSkip)) {
                return null;
            }
            return clazz;
        }

        private RfField getSequenceItemOrNull(RfHid rfHid) {
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfField)) {
                return null;
            }
            RfField field = (RfField)element;
            RfClass type = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (type == null || !this.isSequenceItem(type, this.sequenceItemClass, this.sequenceClass)) {
                return null;
            }
            return field;
        }

        public boolean isSequenceItem(RfClass child, RfClass baseClass, RfClass excludedBaseClass) {
            if (child == null || baseClass == null) {
                return false;
            }
            RfClass parent = child;
            do {
                if (parent.equals(baseClass) || parent.getGenericClass().equals(baseClass)) {
                    return true;
                }
                if (!parent.equals(excludedBaseClass) && !parent.getGenericClass().equals(excludedBaseClass)) continue;
                return false;
            } while ((parent = parent.getParent()) != null);
            return false;
        }

        private List<MethodCall> getMethodCall(IHidObject rightHid) {
            List<MethodCall> methodCalls = new ArrayList();
            if (rightHid instanceof RfHid) {
                IRfNamedElement element = ((RfHid)rightHid).getElement();
                if (!(element instanceof RfFunction)) {
                    return null;
                }
                methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)rightHid));
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return null;
                }
                return methodCalls;
            }
            if (!(rightHid instanceof RfHidAccessArgs)) {
                return null;
            }
            MethodCall methodCall = ((RfHidAccessArgs)rightHid).getMethodCall();
            if (methodCall == null || methodCall.method == null) {
                return null;
            }
            methodCalls.add(methodCall);
            return methodCalls;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

