/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1275")
@CheckName(value="R.1275")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ENVIRONMENT, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Check that there is a config class for each environment class")
@CheckDescription(value="Define dedicated configuration objects using the suffix _config. To clearly identify the relation to the component and sequence, use the same class name as prefix.\n\nExample:\n\nclass my_top_env extends uvm_env;\nendclass\n\nclass my_top_config extends uvm_object;\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1275
extends AbstractConfigClassCheck {
    private static final String ENVSUFFIX = "_env";
    private static final String CONFIGOBJSUFFIX = "_config";

    public Check_R_1275(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        RfClass uvmEnv = this.fOVMProject.fOvmEnv;
        if (uvmEnv == null) {
            return;
        }
        Set<RfClass> allEnvs = this.fOVMProject.getAllXVMSubClasses(uvmEnv);
        RfClass[] allClasses = this.fOVMProject.getRfProject().getAllClasses();
        ArrayList<String> configClassNames = new ArrayList<String>();
        RfClass[] rfClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            if (this.checkConfigClass(clazz)) {
                configClassNames.add(clazz.getFullName());
            }
            ++n2;
        }
        for (RfClass env : allEnvs) {
            String configObjName;
            String envName = env.getFullName();
            if (!envName.endsWith(ENVSUFFIX) || configClassNames.contains(configObjName = envName.substring(0, envName.length() - ENVSUFFIX.length()).concat(CONFIGOBJSUFFIX))) continue;
            this.addHit(env.getNamedElement(), "Environment '" + LintUtils.getNamedElementFullName(env) + "' should have a dedicated configuration object!");
        }
    }
}

