/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1276")
@CheckName(value="R.1276")
@CheckLabel(labels={RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VIRTUAL_SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual sequences should be started on the virtual sequencer")
@CheckDescription(value="Starting a virtual sequence without a sequencer is not allowed.\nVirtual sequences should be started on the virtual sequencer to access common properties stored in a sequencer object or to access the configuration database.\n\nExample:\nseq.start(null);       // not allowed\nseq.start(sequencer);  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1276
extends OVMComplianceCheck {
    public Check_R_1276(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequenceItem == null || this.fOVMProject.fOvmSequence == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1276.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1276.this.notifyCheckAlive();
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!function.isTask()) {
                    return true;
                }
                if (!"start".equals(function.getName())) {
                    return true;
                }
                Hid parentHid = rfHid.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement parentElement = parentHid.getElement();
                if (!(parentElement instanceof RfField)) {
                    return true;
                }
                RfField parentField = (RfField)parentElement;
                RfNamedElement fieldType = LintUtils.getAssociatedFinalType(parentField);
                if (!(fieldType instanceof RfClass)) {
                    return true;
                }
                RfClass fieldClass = (RfClass)fieldType;
                if (!LintUtils.isSubClassOf(fieldClass, ((Check_R_1276)Check_R_1276.this).fOVMProject.fOvmSequence)) {
                    return true;
                }
                if (!LintUtils.isVirtualSequence(fieldClass, ((Check_R_1276)Check_R_1276.this).fOVMProject.fOvmSequence, ((Check_R_1276)Check_R_1276.this).fOVMProject.fOvmSequenceItem)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                block0: for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement argument = (IRfNamedElement)entry.getKey();
                        IHidObject argumentValue = (IHidObject)entry.getValue();
                        if (!"sequencer".equals(argument.getName())) continue;
                        if (!(argumentValue instanceof RfHidImplicit) || !"null".equals(((RfHidImplicit)argumentValue).getName())) continue block0;
                        Check_R_1276.this.addHit(this.parserPath, rfHid, "Virtual sequence '" + LintUtils.getNamedElementFullName(parentField) + "' is calling 'start' without a virtual sequencer!");
                        continue block0;
                    }
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

