/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1277")
@CheckName(value="R.1277")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION, RuleLabel.ARGUMENT})
@CheckTitle(value="Do not use an absolute hierarchical path name as the second argument to uvm_config_db::set")
@CheckDescription(value="In general, if you do need to reach down into the component hierarchy from a test or env, use a wildcard at the start of the path name and provide the shortest possible unique name.\n\nExamples:\n\nuvm_config_db#()::set(this, \"my_env.slave_agent\", \"m_config\", m_config); // not allowed\n\nuvm_config_db#()::set(null, \"*my_env.slave_agent\", \"m_config\", m_config); // allowed\n\nuvm_config_db#()::set(null, \"cfg\", \"m_config\", m_config); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1277
extends OVMComplianceCheck {
    static final String CHECKED_METHOD_NAME = "uvm_pkg::uvm_config_db.set";
    Set<RfNamedElement> topModules;
    Set<ParserPath> topModulesFiles;

    public Check_R_1277(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.topModules = LintUtils.getTopModules(this.fOVMProject);
        this.topModulesFiles = new HashSet<ParserPath>();
        for (RfNamedElement topModule : this.topModules) {
            ParserPath modulePath;
            RfFileDef moduleFile = topModule.getFile();
            if (moduleFile == null || (modulePath = moduleFile.getParserPath()) == null) continue;
            this.topModulesFiles.add(modulePath);
        }
        rfProject.visitHidObject(rfProject, new LocalHidVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    extends RfHidVisitor {
        RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null || this.scope == null) {
                return true;
            }
            if (Check_R_1277.this.topModulesFiles.contains(this.parserPath)) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null || Check_R_1277.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            if (Check_R_1277.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)element;
            Check_R_1277.this.notifyCheckAlive();
            String methodName = method.getFullName();
            if (!methodName.equals(Check_R_1277.CHECKED_METHOD_NAME)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    IHidObject value;
                    RfField configField;
                    IRfNamedElement key = (IRfNamedElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("inst_name") || !((value = (IHidObject)entry.getValue()) instanceof RfHidImplicit) || ((RfHidImplicit)value).getName().startsWith("\"*") || !((RfHidImplicit)value).getName().contains(".")) continue;
                    Check_R_1277.this.addHit(this.parserPath, hidObject, "The second argument of uvm_db_config::set, " + ((RfHidImplicit)value).getName() + ", should not be an absolute hierarchical path!");
                }
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

