/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.2.24")
@CheckID(value="R.1278")
@CheckName(value="R.1278")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not execute sequence items from virtual sequences")
@CheckDescription(value="Executing a sequence item from a virtual sequence is not allowed.\nVirtual sequencers do not have items associated with them, only sequences.\n\nExample:\n`uvm_do(req)                // not allowed\n`uvm_do_on(req, sequencer)  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1278
extends OVMComplianceCheck {
    private static final String UVM_DO = "`uvm_do";
    private static final String UVM_DO_WITH = "`uvm_do_with";
    private static final HashSet<String> UVM_DO_MACROS = new HashSet();

    static {
        UVM_DO_MACROS.add(UVM_DO);
        UVM_DO_MACROS.add(UVM_DO_WITH);
    }

    public Check_R_1278(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        super.preBuildNotification(aRfProject);
        aRfProject.lintTrackMacrosByNames("function", UVM_DO_MACROS);
        aRfProject.lintTrackMacrosByNames("constructor", UVM_DO_MACROS);
        aRfProject.lintTrackMacrosByNames("task", UVM_DO_MACROS);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequenceItem == null || this.fOVMProject.fOvmSequence == null) {
            return;
        }
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        if (allSequences.isEmpty()) {
            return;
        }
        for (RfClass clazz : allSequences) {
            List<RfFunction> classMethods;
            if (clazz.getDeclaration() != null && this.checkPreWaivers(clazz.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            if (!LintUtils.isVirtualSequence(clazz, this.fOVMProject.fOvmSequence, this.fOVMProject.fOvmSequenceItem) || (classMethods = clazz.getLocalMembers(RfFunction.class)) == null || classMethods.isEmpty()) continue;
            for (RfFunction method : classMethods) {
                this.analyzeMethod(clazz, method);
            }
        }
    }

    private void analyzeMethod(final RfClass clazz, RfFunction method) {
        method.visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                IReparseInfo reparseInfo = rfHid.getReparseInfo();
                if (!(reparseInfo instanceof ReparseInfo)) {
                    return true;
                }
                ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparseInfo).getReparseStack();
                if (!UVM_DO_MACROS.contains("`" + reparseStack[0].getReparseMacroName())) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!"start_item".equals(element.getName())) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls == null) {
                    return true;
                }
                block0: for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        RfNamedElement argumentType;
                        RfHid valueHid;
                        IRfNamedElement valueElement;
                        IRfNamedElement argument = (IRfNamedElement)entry.getKey();
                        IHidObject argumentValue = (IHidObject)entry.getValue();
                        if (!"item".equals(argument.getName())) continue;
                        if (!(argumentValue instanceof RfHid) || !((valueElement = (valueHid = (RfHid)argumentValue).getElement()) instanceof RfAssociatedType) || !((argumentType = LintUtils.getAssociatedFinalType((RfAssociatedType)valueElement)) instanceof RfClass) || !LintUtils.isSubClassOf((RfClass)argumentType, ((Check_R_1278)Check_R_1278.this).fOVMProject.fOvmSequenceItem) || LintUtils.isSubClassOf((RfClass)argumentType, ((Check_R_1278)Check_R_1278.this).fOVMProject.fOvmSequence)) continue block0;
                        Check_R_1278.this.addHit(this.parserPath, rfHid.getLine(), "Sequence item '" + valueElement.getName() + "' started from virtual sequence '" + LintUtils.getNamedElementFullName(clazz) + "'!", null);
                        continue block0;
                    }
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

