/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1279")
@CheckName(value="R.1279")
@CheckLabel(labels={RuleLabel.SEQUENCE, RuleLabel.VIRTUAL_SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not start virtual sequences and normal sequences in parallel")
@CheckDescription(value="This check flags non virtual sequences started at the same time as virtual sequences.\nStart() calls are flagged for non virtual sequences in a fork/join when a virtual sequence is also started in the same fork/join.\nWhen starting multiple sequences in parallel these should all be virtual.\n\nExamples:\nfork\n  seq.start(); // not allowed\n  vseq.start();\njoin\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1279
extends OVMComplianceCheck {
    private RfClass defaultParameterClass;
    private Map<RfNamedElement, Map<Boolean, List<SequenceStartInfo>>> sequenceStartMap;

    public Check_R_1279(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.defaultParameterClass = this.fOVMProject.fOvmSequenceItem;
        if (this.defaultParameterClass == null) {
            return;
        }
        RfClass xvmSequenceClass = this.fOVMProject.fOvmSequence;
        if (xvmSequenceClass == null) {
            return;
        }
        String xvmSequenceBaseClassString = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_base");
        RfClass xvmSequenceBaseClass = this.fOVMProject.getRfProject().getClass(xvmSequenceBaseClassString, true);
        if (xvmSequenceBaseClass == null) {
            xvmSequenceBaseClass = xvmSequenceClass;
        }
        this.sequenceStartMap = new HashMap<RfNamedElement, Map<Boolean, List<SequenceStartInfo>>>();
        StartCallVisitor visitor = new StartCallVisitor(xvmSequenceClass, xvmSequenceBaseClass);
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        for (Map.Entry<RfNamedElement, Map<Boolean, List<SequenceStartInfo>>> entry : this.sequenceStartMap.entrySet()) {
            Map<Boolean, List<SequenceStartInfo>> map = entry.getValue();
            if (!map.containsKey(true) || map.get(true) == null || map.get(true).isEmpty() || !map.containsKey(false) || map.get(false) == null || map.get(false).isEmpty()) continue;
            List<SequenceStartInfo> normalSequencesStart = map.get(false);
            List<SequenceStartInfo> virtualSequencesStart = map.get(true);
            Collections.sort(virtualSequencesStart, (seq1, seq2) -> seq1.getLine() - seq2.getLine());
            for (SequenceStartInfo seqStart : normalSequencesStart) {
                StringBuilder message = new StringBuilder();
                for (SequenceStartInfo vseqStart : virtualSequencesStart) {
                    if (vseqStart.getSecondaryScope() != null && seqStart.getSecondaryScope() != null && vseqStart.getSecondaryScope().equals(seqStart.getSecondaryScope())) continue;
                    message.append(String.valueOf(System.lineSeparator()) + this.link("'" + LintUtils.getNamedElementFullName(vseqStart.getField()) + "' at line " + vseqStart.getLine() + " in file '" + LintUtils.getFileShortName(vseqStart.getParserPath().path) + "'", vseqStart.getParserPath().path, vseqStart.getLine()));
                }
                if (message.length() <= 0) continue;
                this.addHit(seqStart.getParserPath(), seqStart.getLine(), "Non-virtual sequence '" + LintUtils.getNamedElementFullName(seqStart.getField()) + "' started in parallel with virtual sequence" + (virtualSequencesStart.size() == 1 ? "" : "s") + ":" + message.toString(), null);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static class SequenceStartInfo {
        private ParserPath parserPath;
        private RfField field;
        private RfActionBlock secondaryScope;
        private boolean isVirtual;
        private int line;

        public SequenceStartInfo(ParserPath parserPath, RfField field, RfActionBlock secondaryScope, boolean isVirtual, int line) {
            this.parserPath = parserPath;
            this.field = field;
            this.secondaryScope = secondaryScope;
            this.isVirtual = isVirtual;
            this.line = line;
        }

        public int getLine() {
            return this.line;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public RfField getField() {
            return this.field;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public RfActionBlock getSecondaryScope() {
            return this.secondaryScope;
        }
    }

    class StartCallVisitor
    extends RfHidVisitor {
        private RfClass xvmSequenceClass;
        private RfClass xvmSequenceBaseClass;

        public StartCallVisitor(RfClass baseSequenceClass, RfClass baseSequenceBaseClass) {
            this.xvmSequenceClass = baseSequenceClass;
            this.xvmSequenceBaseClass = baseSequenceBaseClass;
        }

        public boolean visit(RfHid rfHid) {
            Check_R_1279.this.notifyCheckAlive();
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            RfNamedElement scope = (RfNamedElement)((RfHidHolder)this.holder).getScope();
            if (scope == null || scope.getFile() == null || Check_R_1279.this.fOVMProject.isOVMFile(scope.getFile().getName())) {
                return true;
            }
            if (Check_R_1279.this.checkPreWaivers(scope.getFile().getParserPath())) {
                return true;
            }
            IRfNamedElement resolvedElement = rfHid.getElement();
            if (!(resolvedElement instanceof RfFunction)) {
                return true;
            }
            if (!"start".equals(resolvedElement.getName())) {
                return true;
            }
            Hid parentHid = rfHid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)parentElement;
            RfClass sequence = LintUtils.getFieldFinalClassTypeOrNull(field);
            IReparseInfo reparseInfo = rfHid.getReparseInfo();
            if (reparseInfo instanceof ReparseInfo && LintUtils.isSubClassOf(sequence, this.xvmSequenceBaseClass) && Check_R_1279.this.fOVMProject.isReparseStackInOVMFile((ReparseInfo)reparseInfo)) {
                RfNamedElement enclosingScope = scope.getEnclosingScope();
                RfHidHolder hidHolder = enclosingScope.getHidHolder();
                Map map = hidHolder.getHidObjectsMap();
                if (enclosingScope == null || hidHolder == null || map == null) {
                    return true;
                }
                block0: for (Map.Entry entry : map.entrySet()) {
                    ListContainer list = (ListContainer)entry.getValue();
                    if (list == null || list.isEmpty()) {
                        return true;
                    }
                    for (IHidObject hidObject : list) {
                        List methodCalls;
                        RfHid rfHidObject;
                        if (!(hidObject instanceof RfHid) || !"$cast".equals((rfHidObject = (RfHid)hidObject).getName()) || (methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHidObject)) == null || methodCalls.isEmpty()) continue;
                        for (MethodCall methodCall : methodCalls) {
                            if (methodCall.argumentValuesMapRaw == null) continue;
                            for (Map.Entry argumentsEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                                RfHid valueHid;
                                IRfNamedElement argument = (IRfNamedElement)argumentsEntry.getKey();
                                IHidObject argumentValue = (IHidObject)argumentsEntry.getValue();
                                if (!"source_exp".equals(argument.getName())) continue;
                                if (!(argumentValue instanceof RfHid) || !((valueHid = (RfHid)argumentValue).getElement() instanceof RfField)) continue block0;
                                field = (RfField)valueHid.getElement();
                                sequence = LintUtils.getFieldFinalClassTypeOrNull(field);
                                continue block0;
                            }
                            continue block0;
                        }
                        continue block0;
                    }
                }
            }
            if (sequence == null || !LintUtils.isSubClassOf(sequence, this.xvmSequenceClass)) {
                return true;
            }
            RfActionBlock secondaryScope = null;
            RfActionBlock forkScope = null;
            while (scope != null) {
                if (scope instanceof RfActionBlock && ((RfActionBlock)scope).hasForkJoin()) {
                    forkScope = (RfActionBlock)scope;
                }
                if (forkScope == null && scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBeginEnd()) {
                    secondaryScope = (RfActionBlock)scope;
                }
                scope = scope.getEnclosingScope();
            }
            if (forkScope == null || !forkScope.hasForkJoin()) {
                return true;
            }
            SequenceStartInfo seqStart = new SequenceStartInfo(this.parserPath, field, secondaryScope, LintUtils.isVirtualSequence(sequence, this.xvmSequenceClass, Check_R_1279.this.defaultParameterClass), rfHid.getLine());
            if (!Check_R_1279.this.sequenceStartMap.containsKey(forkScope) && Check_R_1279.this.sequenceStartMap.get(forkScope) == null) {
                map = new HashMap<Boolean, List<SequenceStartInfo>>();
                list = new ArrayList();
                list.add(seqStart);
                map.put(seqStart.isVirtual(), list);
                map.put(!seqStart.isVirtual(), new ArrayList());
                Check_R_1279.this.sequenceStartMap.put(forkScope, map);
            } else {
                map = Check_R_1279.this.sequenceStartMap.get(forkScope);
                list = map.get(seqStart.isVirtual());
                list.add(seqStart);
            }
            return true;
        }
    }
}

