/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.25")
@CheckID(value="R.1280")
@CheckName(value="R.1280")
@CheckLabel(labels={RuleLabel.ENVIRONMENT, RuleLabel.REGISTER_BLOCK, RuleLabel.REGISTER_MODEL, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="A UVM environment should only instantiate a register block if the variable regmodel is null")
@CheckDescription(value="This rule checks if there is an 'if' block with a 'regmodel == null' condition before instantiating the regmodel.\n\nExamples:\nregmodel = new();     // not allowed\nif (regmodel == null)\n  regmodel = new();   // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1280
extends OVMComplianceCheck {
    private static final String CREATE_METHOD_NAME = "uvm_pkg::uvm_object_registry.create";
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private RfClass uvmEnvClass;
    private RfClass uvmRegBlock;

    public Check_R_1280(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlock == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmEnvClass = this.fOVMProject.getRfProject().getClass(UVM_ENV, true);
        if (this.uvmEnvClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        Set<RfClass> allXVMSubClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmEnvClass);
        if (allXVMSubClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allXVMSubClasses) {
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            RegModelInstantiationVisitor visitor = new RegModelInstantiationVisitor();
            clazz.visitHidObject(null, (IHidVisitor<?>)visitor);
        }
    }

    private class RegModelInstantiationVisitor
    extends HidOperatorVisitor {
        private IRfNamedElement enclosingScope;

        public RegModelInstantiationVisitor() {
            super(null);
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.enclosingScope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(HidOperator operator) {
            RfClass lhType;
            if (!operator.isAssignment()) {
                return true;
            }
            Check_R_1280.this.notifyCheckAlive();
            IHidObject lhValue = operator.getLHValue();
            ListContainer rhValues = operator.getRHValues();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement instanceLhElement = lhHid.getElement();
            if (instanceLhElement instanceof RfField && ((lhType = LintUtils.getFieldFinalClassTypeOrNull((RfField)instanceLhElement)) == null || !LintUtils.isSubClassOf(lhType, Check_R_1280.this.uvmRegBlock))) {
                return true;
            }
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs rhHidAccessArgs = (RfHidAccessArgs)((Object)rhValues.get(0));
            Hid functionRhHid = rhHidAccessArgs.getParentHid();
            if (!(functionRhHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement rhElement = functionRhHid.getElement();
            if (!(rhElement instanceof RfFunction)) {
                return true;
            }
            RfFunction rhFunction = (RfFunction)rhElement;
            if (!rhFunction.isConstructor() && !Check_R_1280.CREATE_METHOD_NAME.equals(rhFunction.getFullName())) {
                return true;
            }
            boolean hasCheck = false;
            RfNamedElement scopeIterator = (RfNamedElement)this.enclosingScope;
            while (scopeIterator instanceof RfActionBlock) {
                block11: {
                    IRfNamedElement checkedElement;
                    IHidObject regmodelObj;
                    block13: {
                        RfHidOperator equals;
                        block12: {
                            IHidObject conditionObj;
                            if (!(scopeIterator instanceof RfActionBlock) || !((RfActionBlock)scopeIterator).isIf() || (conditionObj = ((RfActionBlock)scopeIterator).getConditionalBlockExpression()) == null || !(conditionObj instanceof RfHidOperator) || !(equals = (RfHidOperator)conditionObj).isEquality()) break block11;
                            regmodelObj = equals.getLHValue();
                            if (equals.getFirstRHValue() != null && equals.getFirstRHValue() instanceof HidImplicit && ((HidImplicit)equals.getFirstRHValue()).getName().equals("null")) break block12;
                            if (equals.getLHValue() == null || !(equals.getLHValue() instanceof HidImplicit) || !((HidImplicit)equals.getLHValue()).getName().equals("null")) break block11;
                            regmodelObj = equals.getFirstRHValue();
                            break block13;
                        }
                        regmodelObj = equals.getLHValue();
                    }
                    if (regmodelObj != null && regmodelObj instanceof RfHid && (checkedElement = ((RfHid)regmodelObj).getElement()) != null && checkedElement instanceof RfField && checkedElement.equals(instanceLhElement)) {
                        hasCheck = true;
                    }
                }
                scopeIterator = scopeIterator.getEnclosingScope();
            }
            if (!hasCheck) {
                Check_R_1280.this.addHit(this.parserPath, (RfHid)functionRhHid, "Reg block '" + LintUtils.getNamedElementFullName((RfNamedElement)instanceLhElement) + "' should be checked for null before instantiating!");
            }
            return true;
        }
    }
}

