/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractPipelineDriverCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1281")
@CheckName(value="R.1281")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.VERIFICATION})
@CheckTitle(value="Always use the semaphore/mailbox/event for pipeline drivers")
@CheckDescription(value="A pipeline driver is a driver that calls the get_next_item and item_done method in a single sub-task and not in the run_phase.\nThis rule will fail if a pipeline drivers doesn't declare or use an sempahore, mailbox or event.\n\nExample:\nclass my_driver extends xvm_driver#();  // not allowed\n\n\tvirtual task get_and_drive();\n\t\tseq_item_port.get_next_item(req);\n\t\tseq_item_port.item_done(req);\n\tendtask\nendclass \n\nclass my_driver extends xvm_driver#();  // allowed\n semaphore semaph;\n\n\tvirtual task get_and_drive();\n\t\tseq_item_port.get_next_item(req);\n\t\tseq_item_port.item_done(req);\n\tendtask\nendclass \n\nCheck supports pre-waiving.")
public class Check_R_1281
extends AbstractPipelineDriverCheck {
    public Check_R_1281(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkDriver(RfClass driver) {
        PipelineDriverVisitor visitor = new PipelineDriverVisitor();
        driver.visitHidObject(null, visitor);
        if (!visitor.isPipeline()) {
            return;
        }
        if (visitor.hasSemaphoreMailboxOrEvent()) {
            return;
        }
        List<RfField> localFields = driver.getLocalMembers(RfField.class);
        if (localFields != null) {
            boolean hasSemaphoreMailboxOrEvent = false;
            for (RfField field : localFields) {
                RfPredefinedClass fieldClass;
                RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
                if (fieldType instanceof RfPredefinedEventType) {
                    hasSemaphoreMailboxOrEvent = true;
                    break;
                }
                if (fieldType instanceof RfSpecializedClass) {
                    fieldType = ((RfSpecializedClass)fieldType).getGenericClass();
                }
                if (!(fieldType instanceof RfPredefinedClass) || !"semaphore".equals((fieldClass = (RfPredefinedClass)fieldType).getName()) && !"mailbox".equals(fieldClass.getName())) continue;
                hasSemaphoreMailboxOrEvent = true;
                break;
            }
            if (hasSemaphoreMailboxOrEvent) {
                return;
            }
        }
        this.addHit(driver, "Pipeline driver '" + LintUtils.getNamedElementFullName(driver) + "' is not using a semaphore/mailbox/event!");
    }

    private class PipelineDriverVisitor
    extends AbstractPipelineDriverCheck.AbstractVisitor {
        private boolean hasSemaphoreMailboxOrEvent;

        private PipelineDriverVisitor() {
        }

        @Override
        protected void additionalFieldChecks(RfField field) {
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
            if (fieldType instanceof RfPredefinedEventType) {
                this.hasSemaphoreMailboxOrEvent = true;
                return;
            }
            if (fieldType instanceof RfSpecializedClass) {
                fieldType = ((RfSpecializedClass)fieldType).getGenericClass();
            }
            if (!(fieldType instanceof RfPredefinedClass)) {
                return;
            }
            RfPredefinedClass fieldClass = (RfPredefinedClass)fieldType;
            if (!"semaphore".equals(fieldClass.getName()) && !"mailbox".equals(fieldClass.getName())) {
                return;
            }
            this.hasSemaphoreMailboxOrEvent = true;
        }

        public boolean hasSemaphoreMailboxOrEvent() {
            return this.hasSemaphoreMailboxOrEvent;
        }
    }
}

