/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1282")
@CheckName(value="R.1282")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.COMPONENT, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="A component instance may be with one or no configuration object")
@CheckDescription(value="A component instance may be associated with one configuration object or with no configuration object, and several component instances may be associated with the same configuration object\n\nExamples:\n\nclass my_agent extends uvm_agent;\n\tmy_config configobj;\nendclass\n\nclass my_other agent extends uvm_agent;\n\tmy_other_config config2;\nendclass\n\nclass my_env extends uvm_env\n\tmy_config env_config;\n\tmy_agent agent1; // allowed\n\tmy_other_agent agent2; // not allowed - the verification hierarchy of the environment 'my_env' would be using two different types of configuration objects\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class Check_R_1282
extends AbstractConfigClassCheck {
    Collection<RfClass> testBenches;
    private static final String ERROR_MESSAGE_FORMAT = "Environment ''{0}'' is associated with more than one configuration object:\n{1}";

    public Check_R_1282(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        RfClass uvmEnv = this.fOVMProject.fOvmEnv;
        this.testBenches = this.getClassesWithPatterns("testbenchClassNamePattern").values();
        if (uvmEnv == null) {
            return;
        }
        Set<RfClass> allEnvs = this.fOVMProject.getAllXVMSubClasses(uvmEnv);
        for (RfClass env : allEnvs) {
            Map<RfClass, Set<RfField>> configObjects;
            if (this.testBenches.contains(env) || (configObjects = this.getConfigObjects(env, new HashSet<RfClass>())).keySet().size() <= 1) continue;
            this.addHit(env.getNamedElement(), this.getErrorMessage(env, configObjects));
        }
    }

    private Map<RfClass, Set<RfField>> getConfigObjects(RfClass currentClass, Set<RfClass> visited) {
        visited.add(currentClass);
        Map<RfClass, Set<RfField>> configObjects = new LinkedHashMap<RfClass, Set<RfField>>();
        if (this.checkPreWaivers(currentClass.getFile())) {
            return configObjects;
        }
        List<RfField> fields = currentClass.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null) {
            return configObjects;
        }
        for (RfField field : fields) {
            RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field, RfTypesResolver.create((IRfScopeElement)currentClass, currentClass.getRfProject(), 6));
            this.notifyCheckAlive();
            if (fieldClass == null || this.fOVMProject.isOVMElement(fieldClass.getNamedElement()) || visited.contains(fieldClass)) continue;
            if (this.checkConfigClass(fieldClass)) {
                LinkedHashSet<RfField> configObject = (LinkedHashSet<RfField>)configObjects.get(fieldClass);
                if (configObject == null) {
                    configObject = new LinkedHashSet<RfField>();
                    configObjects.put(fieldClass, configObject);
                }
                configObject.add(field);
                continue;
            }
            configObjects = this.customPutAll(configObjects, this.getConfigObjects(fieldClass, visited));
        }
        return configObjects;
    }

    private Map<RfClass, Set<RfField>> customPutAll(Map<RfClass, Set<RfField>> configObjects, Map<RfClass, Set<RfField>> configObjects2) {
        for (Map.Entry<RfClass, Set<RfField>> entry : configObjects2.entrySet()) {
            RfClass configClass = entry.getKey();
            Set<RfField> newConfigFields = entry.getValue();
            Set<RfField> currentConfigFields = configObjects.get(configClass);
            if (currentConfigFields == null) {
                currentConfigFields = new LinkedHashSet<RfField>();
                configObjects.put(configClass, currentConfigFields);
            }
            currentConfigFields.addAll(newConfigFields);
        }
        return configObjects;
    }

    private String getErrorMessage(RfNamedElement env, Map<RfClass, Set<RfField>> configObjects) {
        StringBuilder envsMessage = new StringBuilder();
        for (Map.Entry<RfClass, Set<RfField>> entry : configObjects.entrySet()) {
            RfClass configObject = entry.getKey();
            Set<RfField> configObjectInstances = entry.getValue();
            envsMessage.append(" '").append(LintUtils.getNamedElementFullName(configObject.getNamedElement())).append("' instances:").append("\n");
            for (RfField instance : configObjectInstances) {
                ParserPath parserPath;
                RfFileDef instanceFile = instance.getFile();
                if (instanceFile == null || (parserPath = instanceFile.getParserPath()) == null) continue;
                envsMessage.append("  '").append(instance.getName()).append("'").append(this.link(" at line " + instance.getLine() + " of " + LintUtils.getFileShortName(parserPath.toString()), parserPath.toString(), instance.getLine())).append("\n");
            }
        }
        String errorMessage = MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(env.getNamedElement()), envsMessage.toString());
        if (errorMessage.endsWith("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
        }
        return errorMessage;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

