/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractSetConfigurationFunctionCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1283")
@CheckName(value="R.1283")
@CheckLabel(labels={RuleLabel.COMPONENT, RuleLabel.CONFIG_DB, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Each component should get the configuration object associated with that specific component instance")
@CheckDescription(value="Calling uvm_config_db::get() without 'this' as context is not allowed, each component should only access the configuration object associated with that component instance.\n\nExamples:\nuvm_config_db #()::get(uvm_root::get(), \"instance\", \"field\", object); // Not allowed\nuvm_config_db #()::get(this, \"instance\", \"field\", object); // Allowed\n\nCheck supports pre-waiving.")
public class Check_R_1283
extends AbstractSetConfigurationFunctionCheck {
    private static final String ARG_NAME = "cntxt";
    private static final String UVM_COMPONENT = "uvm_pkg::uvm_component";

    public Check_R_1283(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.checkGetConfig = true;
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmComponent == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_component' not found!");
            return;
        }
        Set<RfClass> allComponents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmComponent);
        if (allComponents.isEmpty()) {
            return;
        }
        for (RfClass component : allComponents) {
            component.visitHidObject(this.fOVMProject.getRfProject(), new AbstractSetConfigurationFunctionCheck.SetConfigurationFunctionVisitor());
        }
    }

    @Override
    protected void checkMethodCalls(List<MethodCall> methodCalls, RfHid hid, ParserPath parserPath) {
        if (!hid.isMethodCall(false) || !"get".equals(hid.getName())) {
            return;
        }
        for (MethodCall call : methodCalls) {
            if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
            for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                IHidObject value;
                RfField configField;
                IRfNamedElement key = (IRfNamedElement)entry.getKey();
                if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals(ARG_NAME) || HidUtils.isHid((IHidObject)(value = (IHidObject)entry.getValue())) && "this".equals(((RfHid)value).getName())) continue;
                this.addHit(parserPath, hid, "Function 'uvm_config_db::get()' should be called with 'this' as its first argument instead of '" + HidUtils.toNiceString((IHidObject)value) + "'!");
            }
        }
    }
}

