/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1284")
@CheckName(value="R.1284")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.OBJECTION, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequences that\traise/drop objections must be named as base sequence")
@CheckDescription(value="If a sequence calls raise/drop objection it's name must match the pattern specified by the <baseSequenceNamePattern> parameter.\nThis rule enforces that common code is in one place and makes sure that objections are raised and dropped in sequences.\n\nExample:\n\nclass my_seq extends uvm_sequence;\t\t// not allowed\n\ttask body();\n\t\tuvm_phase p;\n\t\tp.raise_objection(this);\n\t\tp.drop_objection(this);\n\tendtask\nendclass\n\nclass my_base_seq extends uvm_sequence;\t// allowed\n\ttask body();\n\t\tuvm_phase p;\n\t\tp.raise_objection(this);\n\t\tp.drop_objection(this);\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1284
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_base_seq", description="Comma separated list of allowed patterns for the name of the base sequence class.", name="baseSequenceNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pBaseSequenceNamePattern;

    public Check_R_1284(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        DVTStringBuilder sb = new DVTStringBuilder();
        for (Pattern pattern : this.pBaseSequenceNamePattern) {
            sb.append(pattern.toString()).append(", ");
        }
        if (!this.pBaseSequenceNamePattern.isEmpty()) {
            sb.deleteLastChar().deleteLastChar();
        }
        String hitPattern = sb.toString();
        Set<RfClass> sequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        for (RfClass seq : sequences) {
            this.notifyCheckAlive();
            if (this.fOVMProject.isOVMElement(seq) || this.checkPreWaivers(seq.getFile())) continue;
            ObjectionsVisitor visitor = new ObjectionsVisitor();
            seq.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            if (!visitor.hasObjections()) continue;
            boolean patternMatch = false;
            for (Pattern pattern : this.pBaseSequenceNamePattern) {
                if (!pattern.matcher(seq.getName()).matches()) continue;
                patternMatch = true;
                break;
            }
            if (patternMatch) continue;
            this.addHit(seq, "Base sequence class name \"" + seq.getName() + "\" does not respect the \"" + hitPattern + "\" name pattern!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class ObjectionsVisitor
    extends RfHidVisitor {
        private boolean hasObjections = false;

        public boolean hasObjections() {
            return this.hasObjections;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function.getName().equals("raise_objection") || function.getName().equals("drop_objection")) {
                this.hasObjections = true;
                return false;
            }
            return true;
        }
    }
}

