/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractBaseClassCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="23.2.29")
@CheckID(value="R.1285")
@CheckName(value="R.1285")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.CLASS, RuleLabel.OBJECT, RuleLabel.NAME, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="Create user defined configuration classes by extending the class xvm_object")
@CheckDescription(value="Configuration classes that have a name matching the .*_config pattern should extend xvm_object.\nThis rule can check if class that matches <namePattern> extends the <baseClass>.\n\nExample with namePattern = '.*_config' and baseClass = 'xvm_pkg::xvm_object':\n\nclass test_config extends xvm_object; endclass     //allowed\nclass test_config; endclass      // not allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="baseClass", defaultValue="xvm_pkg::xvm_object")
public class Check_R_1285
extends AbstractBaseClassCheck {
    @CheckParameter(defaultValue=".*_config", description="Name pattern for user defined classes.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pNamePattern;

    public Check_R_1285(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getComponentName() {
        return "Class ";
    }

    @Override
    protected RfClass getBaseClass() {
        if (!this.pBaseClassValue.isEmpty()) {
            return this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        }
        return null;
    }

    @Override
    protected Collection<RfClass> getComponents() {
        return this.fOVMProject.getAllClasses().stream().filter(x -> this.pNamePattern.matcher(x.getName()).matches()).collect(Collectors.toList());
    }
}

