/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractPipelineDriverCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1286")
@CheckName(value="R.1286")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.VERIFICATION})
@CheckTitle(value="The driver should mark the item done in the first stage of the pipeline")
@CheckDescription(value="A pipeline driver is a driver that calls the get_next_item and item_done method in a single sub-task and not in the run_phase.\nThis sub_task must be the first task called in the run_phase (except for reset).\n\nExample:\nclass my_driver extends xvm_driver#();  // not allowed\n\n  virtual task run_phase(xvm_phase phase);\n    super.run_phase(phase);\n  endtask\n\n\tvirtual task get_and_drive();\n\t\tseq_item_port.get_next_item(req);\n\t\tseq_item_port.item_done(req);\n\tendtask\nendclass \n\nclass my_driver extends xvm_driver#();  // allowed\n\n  virtual task run_phase(xvm_phase phase);\n    super.run_phase(phase);\n    get_and_drive();\n  endtask\n\n\tvirtual task non_run_phase(uvm_phase phase);\n\t\tseq_item_port.get_next_item(req);\n\t\tseq_item_port.item_done(req);\n\tendtask\nendclass \n\nCheck supports pre-waiving.")
public class Check_R_1286
extends AbstractPipelineDriverCheck {
    public Check_R_1286(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkDriver(RfClass driver) {
        PipelineDriverVisitor visitor = new PipelineDriverVisitor();
        driver.visitHidObject(null, visitor);
        if (!visitor.isPipeline()) {
            return;
        }
        if (visitor.isPipelineTaskCorrectlyCalled()) {
            return;
        }
        this.addHit(driver, "Pipeline driver '" + LintUtils.getNamedElementFullName(driver) + "' should firstly call the '" + LintUtils.getNamedElementFullName(visitor.getPipelineScope()) + "' sub-task in the run_phase!");
    }

    private class PipelineDriverVisitor
    extends AbstractPipelineDriverCheck.AbstractVisitor {
        private RfFunction pipelineScope;
        private DVTPair<HidOccurrence, RfFunction> firstTaskCalled;

        private PipelineDriverVisitor() {
        }

        @Override
        protected void additionalMethodChecks(RfHid hidObject, RfFunction function, RfFunction functionScope) {
            if (!"run_phase".equals(functionScope.getName())) {
                return;
            }
            if (LintUtils.isSuper(hidObject) || "reset_phase".equals(function.getName())) {
                return;
            }
            if (this.firstTaskCalled == null) {
                this.firstTaskCalled = new DVTPair((Object)hidObject.getOccurrence(), (Object)function);
            } else {
                int oldOffset;
                int offset = hidObject.getOccurrence().getOffset();
                if (offset == (oldOffset = ((HidOccurrence)this.firstTaskCalled.getKey()).getOffset())) {
                    offset = hidObject.getOccurrence().getVirtualOffset();
                    oldOffset = ((HidOccurrence)this.firstTaskCalled.getKey()).getVirtualOffset();
                }
                if (offset < oldOffset) {
                    this.firstTaskCalled = new DVTPair((Object)hidObject.getOccurrence(), (Object)function);
                }
            }
        }

        @Override
        protected void setPipeline(RfFunction function, RfFunction functionScope) {
            super.setPipeline(function, functionScope);
            this.pipelineScope = functionScope;
        }

        public RfFunction getPipelineScope() {
            return this.pipelineScope;
        }

        public boolean isPipelineTaskCorrectlyCalled() {
            return this.firstTaskCalled != null && this.pipelineScope.equals(this.firstTaskCalled.getValue());
        }
    }
}

