/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1287")
@CheckName(value="R.1287")
@CheckLabel(labels={RuleLabel.CONNECT_PHASE, RuleLabel.REGISTER_BLOCK, RuleLabel.REGISTER_MAP, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="The address map variable of the predictor in each child register block should be assigned to the corresponding address map of the top level register block")
@CheckDescription(value="For each env with a register block and predictor, it's mandatory to assign the register block map to the preditor map in the connect phase.\n\nExample:\nuvm_reg_predictor predictor;    // allowed\nuvm_reg_predictor predictor2;   // not allowed\n\nvirtual function void connect_phase(uvm_phase phase);\n  predictor.map = regmodel.map;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1287
extends OVMComplianceCheck {
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private static final String UVM_REG_PREDICTOR = "uvm_pkg::uvm_reg_predictor";
    private RfClass uvmRegClass;
    private RfClass uvmPredictorClass;

    public Check_R_1287(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmEnv == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        this.uvmRegClass = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmPredictorClass = this.fOVMProject.getRfProject().getClass(UVM_REG_PREDICTOR, true);
        if (this.uvmPredictorClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_predictor' not found!");
            return;
        }
        Set<RfClass> allEnvs = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmEnv);
        for (RfClass clazz : allEnvs) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> fields = clazz.getFields();
            if (fields == null || fields.isEmpty()) continue;
            HashSet<RfField> regmodelFields = new HashSet<RfField>();
            HashSet<RfField> predictorFields = new HashSet<RfField>();
            for (RfField field : fields) {
                RfClass finalClass;
                if (field == null || (finalClass = LintUtils.getFieldFinalClassTypeOrNull(field)) == null) continue;
                if (LintUtils.isSubClassOf(finalClass, this.uvmRegClass)) {
                    regmodelFields.add(field);
                    continue;
                }
                if (!LintUtils.isSubClassOf(finalClass, this.uvmPredictorClass)) continue;
                predictorFields.add(field);
            }
            if (predictorFields.isEmpty()) continue;
            RfFunction connectPhase = clazz.getFunctionWithPrefix("connect_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (connectPhase != null) {
                connectPhase.visitHidObject(null, (IHidVisitor<?>)new ConnectPhaseVisitor(regmodelFields, predictorFields));
            }
            if (predictorFields.isEmpty()) continue;
            for (RfField predictorField : predictorFields) {
                this.addHit(predictorField, "The address map variable of the predictor '" + LintUtils.getNamedElementFullName(predictorField) + "' should be assigned to a register block map variable!");
            }
        }
    }

    private static class ConnectPhaseVisitor
    extends HidOperatorVisitor {
        Set<RfField> regmodelField;
        Set<RfField> predictorField;

        public ConnectPhaseVisitor(Set<RfField> regmodelField, Set<RfField> predictorField) {
            super(null);
            this.regmodelField = regmodelField;
            this.predictorField = predictorField;
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            RfField leftField = this.getFieldFromHid(lhValue);
            if (leftField == null) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            RfField rightField = this.getFieldFromHid(rhValue);
            if (rightField == null) {
                return true;
            }
            if (this.regmodelField.remove(rightField)) {
                this.predictorField.remove(leftField);
            }
            return true;
        }

        private RfField getFieldFromHid(IHidObject hid) {
            if (hid == null || !(hid instanceof RfHid)) {
                return null;
            }
            RfHid rfHid = (RfHid)hid;
            if (!"map".equals(rfHid.getName())) {
                return null;
            }
            HidAccess parentAccess = rfHid.getParentAccess();
            if (parentAccess == null) {
                return null;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid == null) {
                return null;
            }
            IRfNamedElement element = parentHid.getElement();
            if (element == null || !(element instanceof RfField)) {
                return null;
            }
            return (RfField)element;
        }
    }
}

