/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1288")
@CheckName(value="R.1288")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.RANDOMIZATION, RuleLabel.CONSTRAINT})
@CheckTitle(value="Do not call randomize with constraints")
@CheckDescription(value="Calling randomize with constraints may impact simulation performance.\nAs an alternative, you can set the constraints variable values before the randomize() call or disable the randomization of a variable with rand_mode(0).\n\nExample:\nthis.randomize() with {x <= 2;};                // not allowed\n\nx <= 2;\nx.rand_mode(0);\nthis.randomize();                               // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1288
extends OVMComplianceCheck {
    public Check_R_1288(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1288.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1288.this.notifyCheckAlive();
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!"randomize".equals(function.getName())) {
                    return true;
                }
                HidAccess firstAccess = hidObject.getFirstAccess();
                if (!(firstAccess instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs accessArgs = (RfHidAccessArgs)firstAccess;
                if (!accessArgs.hasWithClause()) {
                    return true;
                }
                Check_R_1288.this.addHit(this.parserPath, hidObject, "Banned randomize with {} call!");
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

