/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Map;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractAnalysisPortCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1289")
@CheckName(value="R.1289")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MACRO, RuleLabel.MONITOR, RuleLabel.ANALYSIS_PORT, RuleLabel.SCOREBOARD, RuleLabel.VERIFICATION})
@CheckTitle(value="Use macro `xvm_analysis_imp_decl(_SFX) to declare the analysis implementation to connect to monitor port and implement the corresponding write method")
@CheckDescription(value="If a scoreboard is declaring multiple analysis implementations, they must be declared using the `xvm_analysis_imp_decl(_SFX) macro in order to connect to monitor port and properly implement the write method.\n\nExample:\n`uvm_analysis_imp_decl(_ahb)\n\nCheck supports pre-waiving.")
public class Check_R_1289
extends AbstractAnalysisPortCheck {
    public Check_R_1289(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void analyzeClass(RfClass clazz) {
        Map<RfField, RfClass> analysisImplementations = this.getAnalysisImplementations(clazz);
        if (analysisImplementations.size() < 2) {
            return;
        }
        for (Map.Entry<RfField, RfClass> entry : analysisImplementations.entrySet()) {
            RfField field = entry.getKey();
            RfClass type = entry.getValue();
            if (this.checkFieldTypeIsValid(type)) continue;
            this.addHit(field, "Analysis implementation of field '" + LintUtils.getNamedElementFullName(field) + "' must be declared using the `" + this.declarationMacroName + " macro!");
        }
    }

    @Override
    protected Set<RfClass> getClasses() {
        return this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmScoreboard);
    }
}

