/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1290")
@CheckName(value="R.1290")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.PARAMETER, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not have parameterized sequences")
@CheckDescription(value="If a sequence is to be parameterized, the parameters should be put into an object in the configuration database.\n\nExamples:\n\nclass my_sequence extends uvm_sequence; // allowed\nendclass\n\nclass my_second_sequence#(type T) extends uvm_sequence; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1290
extends OVMComplianceCheck {
    private Set<RfClass> notParameterizedSequences;

    public Check_R_1290(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequence == null) {
            return;
        }
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        this.notParameterizedSequences = new HashSet<RfClass>();
        if (allSequences.isEmpty()) {
            return;
        }
        this.populateNonParameterizedSequences(allSequences);
        allSequences.removeAll(this.notParameterizedSequences);
        for (RfClass sequence : allSequences) {
            this.addHit(sequence.getNamedElement(), "Sequence '" + LintUtils.getNamedElementFullName(sequence.getNamedElement()) + "' should not be parameterized!");
        }
    }

    private void populateNonParameterizedSequences(Set<RfClass> sequences) {
        for (RfClass sequence : sequences) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile())) continue;
            List<RfField> parameters = sequence.getParametersWithPrefix("", 384, 2, 1);
            boolean hasParameters = false;
            for (RfField parameter : parameters) {
                if (!parameter.isInParameterPortList()) continue;
                hasParameters = true;
                break;
            }
            if (hasParameters) continue;
            this.notParameterizedSequences.add(sequence);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

