/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractAnalysisPortCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1292")
@CheckName(value="R.1292")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.METHOD, RuleLabel.SCOREBOARD, RuleLabel.SUBSCRIBER, RuleLabel.ANALYSIS_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Define the write method to receive the transaction through an analysis port")
@CheckDescription(value="For each analysis port defined in a scoreboard or subscriber, it's required to also implement a writeSFX method, where SFX is the parameter of the `uvm_analysis_imp_decl macro call.\nThis custom write method is called when the transaction is sent through the connected port.\n\nExample:\nuvm_analysis_imp_ahb #(my_transfer, my_scoreboard) ahb_port;\nvirtual function void write_ahb(input my_transfer transfer);\n  // method implementation\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1292
extends AbstractAnalysisPortCheck {
    private RfClass baseSubscriber;

    public Check_R_1292(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String baseSubscriberName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_subscriber");
        this.baseSubscriber = this.fOVMProject.getRfProject().getClass(baseSubscriberName, true);
        if (this.baseSubscriber == null) {
            return;
        }
        super.performCheckImpl();
    }

    @Override
    protected void analyzeClass(RfClass clazz) {
        if (clazz.isVirtual()) {
            return;
        }
        Map<RfField, RfClass> analysisImplementations = this.getAnalysisImplementations(clazz);
        if (analysisImplementations.isEmpty()) {
            return;
        }
        for (Map.Entry<RfField, RfClass> entry : analysisImplementations.entrySet()) {
            RfField imp;
            RfField field = entry.getKey();
            RfClass type = entry.getValue();
            if (!this.checkFieldTypeIsValid(type) || (imp = type.getFieldWithPrefix("m_imp", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null) continue;
            RfClass impType = LintUtils.getFieldFinalClassTypeOrNull(imp, RfTypesResolver.create((IRfScopeElement)type, type.getRfProject(), 6));
            if (!clazz.equals(impType.getGenericClass())) {
                this.addHit(field, "Analysis port '" + LintUtils.getNamedElementFullName(field) + "' is not declared using the enclosed class!");
                continue;
            }
            String methodNameSuffix = type.getName().substring("uvm_analysis_imp".length());
            RfFunction writeMethod = clazz.getFunctionWithPrefix("write" + methodNameSuffix, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (writeMethod != null) continue;
            this.addHit(clazz, "Class '" + clazz.getName() + "' must declare a write method for the '" + LintUtils.getNamedElementFullName(field) + "' analysis port!");
        }
    }

    @Override
    protected Set<RfClass> getClasses() {
        HashSet<RfClass> result = new HashSet<RfClass>();
        result.addAll(this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmScoreboard));
        result.addAll(this.fOVMProject.getAllXVMSubClasses(this.baseSubscriber));
        return result;
    }
}

