/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1293")
@CheckName(value="R.1293")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.CONFIG_DB, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="The code that starts a sequence should get any configuration object from the configuration database")
@CheckDescription(value="If there is a configuration object in a sequence there must be a 'uvm_config_db::get' or an assignment for that configuration object. It can be even outside of the sequence.\n\nExamples:\n\nAllowed:\n\nclass my_sequence extends uvm_sequence;\n  my_config m_config;\n\n  task body();\n    if (!uvm_config_db#(my_config)::get(this, \"*\", \"my_config\", m_config))\n      `uvm_fatal(\"CONFIG\", \"Failed to fetch config object\");\n  endtask\nendclass\n\nNot allowed:\n\nclass my_sequence extends uvm_sequence;\n  my_config m_config;\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1293
extends AbstractConfigClassCheck {
    String CHECKED_METHOD_NAME = "uvm_pkg::uvm_config_db.get";
    Set<RfField> allConfigObjects;

    public Check_R_1293(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        RfProject rfProject = this.fOVMProject.getRfProject();
        this.allConfigObjects = new LinkedHashSet<RfField>();
        if (rfProject == null || this.fOVMProject.fOvmSequence == null) {
            return;
        }
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        for (RfClass sequence : allSequences) {
            RfFileDef sequenceFile = sequence.getFile();
            if (sequenceFile == null || this.checkPreWaivers(sequenceFile.getParserPath())) continue;
            this.notifyCheckAlive();
            List<RfField> members = sequence.getLocalFields();
            if (members == null) continue;
            for (RfField field : members) {
                RfClass fieldClass;
                if (field == null || (fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || this.fOVMProject.isOVMElement(fieldClass.getNamedElement()) || !this.checkConfigClass(fieldClass)) continue;
                this.allConfigObjects.add(field);
            }
        }
        rfProject.visitHidObject(rfProject, new LocalVisitor());
        for (RfField configObject : this.allConfigObjects) {
            this.addHit(configObject.getNamedElement(), "The configuration object '" + LintUtils.getNamedElementFullName(configObject.getNamedElement()) + "' should be set from the configuration database!");
        }
    }

    private final class LocalVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        RfNamedElement scope;

        private LocalVisitor() {
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_R_1293.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1293.this.notifyCheckAlive();
            if (this.scope == null) {
                return true;
            }
            RfFileDef file = this.scope.getFile();
            if (file == null || Check_R_1293.this.fOVMProject.isOVMFile(file.getName())) {
                return true;
            }
            if (hidObject instanceof HidOperator) {
                HidOperator hidOperator = (HidOperator)hidObject;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                IRfNamedElement hidElement = null;
                if (lhValue instanceof RfHidAccess) {
                    hidElement = ((RfHidAccess)lhValue).getAssociatedType();
                } else if (lhValue instanceof RfHid) {
                    hidElement = ((RfHid)lhValue).getElement();
                }
                if (!(hidElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)hidElement;
                RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldClass == null) {
                    return true;
                }
                if (Check_R_1293.this.fOVMProject.isOVMElement(fieldClass.getNamedElement())) {
                    return true;
                }
                Check_R_1293.this.allConfigObjects.remove(field);
            } else if (hidObject instanceof RfHid) {
                RfHid rfHid = (RfHid)hidObject;
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction method = (RfFunction)element;
                String methodName = method.getFullName();
                if (!methodName.equals(Check_R_1293.this.CHECKED_METHOD_NAME)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                block0: for (MethodCall call : methodCalls) {
                    if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                    for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement configElement;
                        RfField configField;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("value")) continue;
                        IHidObject value = (IHidObject)entry.getValue();
                        if (!(value instanceof RfHid) || !((configElement = ((RfHid)value).getElement()) instanceof RfField)) continue block0;
                        Check_R_1293.this.allConfigObjects.remove(configElement);
                    }
                }
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

