/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractConfigClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="23.2.29")
@CheckID(value="R.1294")
@CheckName(value="R.1294")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.CONFIG_OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="All configuration object instance names should match a naming pattern")
@CheckDescription(value="This rule checks that all configuration object instance names match <namePattern>.\n\nImplementation notes:\nA configuration class is a class that extends from xvm_object and has at least one field. \nThe configuration class cannot contain fields of type class with the exception of other configuration class handles.\n\nExamples when namePattern is 'm_config|m_.*_config':\n\nclass example_class;\n   config_class m_test_config; // allowed\n   config_class m_config;      // allowed\n   config_class test_config;   // not allowed, name does not match\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1294
extends AbstractConfigClassCheck {
    @CheckParameter(defaultValue="m_config|m_.*_config", description="All configuration classes instance names must match this pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern namePattern;

    public Check_R_1294(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            if (this.checkPreWaivers(clazz.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            List<RfField> fields = clazz.getFields();
            if (fields == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                Matcher m;
                RfClass fieldClass;
                if (field == null || (fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !this.checkConfigClass(fieldClass) || (m = this.namePattern.matcher(field.getName())).matches()) continue;
                this.addHit(field, "Configuration class instance '" + LintUtils.getNamedElementFullName(field) + "' should match '" + this.namePattern.pattern() + "' pattern!");
            }
        }
    }
}

