/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckReapplyDisable
@CheckVersion(value="24.1.7")
@CheckID(value="R.1295")
@CheckName(value="R.1295")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ENVIRONMENT, RuleLabel.REGISTER_MODEL, RuleLabel.AGENT, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="A UVM environment that uses a register model and instantiates an agent should instantiate and connect a register adapter and a register predictor")
@CheckDescription(value="Every UVM environment that has a register model field and an agent field should instantiate a register adapter and a register predictor in the build_phase.\nIn the connect_phase the adapter should connect to the register model and the predictor should connect to the agent.\n\nConnection examples:\n  my_agent.port.connect(predictor.port);\n  regmodel.default_map.set_sequencer(my_agent.m_sequencer, adapter);\n\nCheck supports pre-waiving.")
public class Check_R_1295
extends OVMComplianceCheck {
    private static final String UVM_OBJECT_REGISTRY_CREATE = "uvm_pkg::uvm_object_registry.create";
    private static final String UVM_COMPONENT_REGISTRY_CREATE = "uvm_pkg::uvm_component_registry.create";
    private static final String UVM_PORT_CONNECT = "uvm_pkg::uvm_port_base.connect";
    private static final String UVM_ENV = "uvm_pkg::uvm_env";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private static final String UVM_AGENT = "uvm_pkg::uvm_agent";
    private static final String UVM_REG_ADAPTER = "uvm_pkg::uvm_reg_adapter";
    private static final String UVM_REG_PREDICTOR = "uvm_pkg::uvm_reg_predictor";
    private RfClass uvmEnvClass;
    private RfClass uvmRegBlock;
    private RfClass uvmAgentClass;
    private RfClass uvmRegAdapter;
    private RfClass uvmRegPredictor;

    public Check_R_1295(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlock == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        this.uvmEnvClass = this.fOVMProject.getRfProject().getClass(UVM_ENV, true);
        if (this.uvmEnvClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        this.uvmAgentClass = this.fOVMProject.getRfProject().getClass(UVM_AGENT, true);
        if (this.uvmAgentClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_agent' not found!");
            return;
        }
        this.uvmRegAdapter = this.fOVMProject.getRfProject().getClass(UVM_REG_ADAPTER, true);
        if (this.uvmRegAdapter == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_adapter' not found!");
            return;
        }
        this.uvmRegPredictor = this.fOVMProject.getRfProject().getClass(UVM_REG_PREDICTOR, true);
        if (this.uvmRegPredictor == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_predictor' not found!");
            return;
        }
        HashSet<RfField> agentFields = new HashSet<RfField>();
        HashSet<RfField> regmodelFields = new HashSet<RfField>();
        Set<RfClass> allEnvClasses = this.fOVMProject.getAllXVMSubClasses(this.uvmEnvClass);
        if (allEnvClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : allEnvClasses) {
            if (clazz == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> fields = clazz.getFields();
            if (fields == null || fields.isEmpty()) continue;
            for (RfField field : fields) {
                if (field == null) continue;
                RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (LintUtils.isSubClassOf(fieldClass, this.uvmAgentClass)) {
                    agentFields.add(field);
                    continue;
                }
                if (!LintUtils.isSubClassOf(fieldClass, this.uvmRegBlock)) continue;
                regmodelFields.add(field);
            }
            if (agentFields.isEmpty() || regmodelFields.isEmpty()) continue;
            RfFunction buildPhase = clazz.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (buildPhase == null) {
                this.addHit(clazz, "There should be a build_phase in class '" + LintUtils.getNamedElementFullName(clazz) + "' to instantiate adaptors and predictors!");
                continue;
            }
            HashSet<RfField> regAdapters = new HashSet<RfField>();
            HashSet<RfField> regPredictors = new HashSet<RfField>();
            buildPhase.visitHidObject(null, (IHidVisitor<?>)new BuildPhaseVisitor(regAdapters, regPredictors));
            if (regAdapters.isEmpty() || regPredictors.isEmpty()) {
                this.addHit(buildPhase, "There should be instantiations of adapters and predictors inside build_phase '" + LintUtils.getNamedElementFullName(buildPhase) + "'!");
                continue;
            }
            RfFunction connectPhase = clazz.getFunctionWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (connectPhase != null) {
                connectPhase.visitHidObject(null, new ConnectPhaseVisitor(regAdapters, regPredictors, regmodelFields, agentFields));
            }
            if (!regAdapters.isEmpty()) {
                for (RfField field : regAdapters) {
                    this.addHit(field, "Instantiated adapter '" + LintUtils.getNamedElementFullName(field) + "' is not connected in the connect_phase!");
                }
            }
            if (regPredictors.isEmpty()) continue;
            for (RfField field : regPredictors) {
                this.addHit(field, "Instantiated predictor '" + LintUtils.getNamedElementFullName(field) + "' is not connected in the connect_phase!");
            }
        }
    }

    private class BuildPhaseVisitor
    extends HidOperatorVisitor {
        Set<RfField> regAdapters;
        Set<RfField> regPredictors;

        public BuildPhaseVisitor(Set<RfField> regAdapters, Set<RfField> regPredictors) {
            super(null);
            this.regAdapters = regAdapters;
            this.regPredictors = regPredictors;
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs rhHidAccessArgs = (RfHidAccessArgs)((Object)rhValues.get(0));
            Hid rhHid = rhHidAccessArgs.getParentHid();
            if (!(rhHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement rhElement = rhHid.getElement();
            if (!(rhElement instanceof RfFunction)) {
                return true;
            }
            RfFunction rhFunction = (RfFunction)rhElement;
            if (!(rhFunction.isConstructor() || Check_R_1295.UVM_OBJECT_REGISTRY_CREATE.equals(rhFunction.getFullName()) || Check_R_1295.UVM_COMPONENT_REGISTRY_CREATE.equals(rhFunction.getFullName()))) {
                return true;
            }
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement lhElement = lhHid.getElement();
            if (lhElement instanceof RfField) {
                RfClass lhType = LintUtils.getFieldFinalClassTypeOrNull((RfField)lhElement);
                if (lhType == null) {
                    return true;
                }
                if (LintUtils.isSubClassOf(lhType, Check_R_1295.this.uvmRegAdapter)) {
                    this.regAdapters.add((RfField)lhElement);
                } else if (LintUtils.isSubClassOf(lhType, Check_R_1295.this.uvmRegPredictor)) {
                    this.regPredictors.add((RfField)lhElement);
                }
            }
            return true;
        }
    }

    private class ConnectPhaseVisitor
    extends RfHidVisitor {
        private static final String UVM_SET_SEQUENCER = "uvm_pkg::uvm_reg_map.set_sequencer";
        Set<RfField> regAdapters;
        Set<RfField> regPredictors;
        Set<RfField> regmodels;
        Set<RfField> agents;

        public ConnectPhaseVisitor(Set<RfField> regAdapters, Set<RfField> regPredictors, Set<RfField> regmodels, Set<RfField> agents) {
            this.regAdapters = regAdapters;
            this.regPredictors = regPredictors;
            this.regmodels = regmodels;
            this.agents = agents;
        }

        public boolean visit(RfHid rfHid) {
            String name = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_R_1295.this.fOVMProject.isOVMFile(name)) {
                return true;
            }
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (((RfFunction)element).getFullName().equals(Check_R_1295.UVM_PORT_CONNECT)) {
                this.checkConnectCall(rfHid);
            } else if (((RfFunction)element).getFullName().equals(UVM_SET_SEQUENCER)) {
                this.checkSetSequenceCall(rfHid);
            }
            return true;
        }

        private void checkSetSequenceCall(RfHid rfHid) {
            IRfNamedElement element;
            RfHid parentHidCall = rfHid;
            do {
                if ((parentHidCall = parentHidCall.getParentHid()) != null) continue;
                return;
            } while (((element = parentHidCall.getElement()) == null || !(element instanceof RfField) || !this.regmodels.contains(element)) && parentHidCall != null);
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    IRfNamedElement parentElement;
                    IHidObject value;
                    RfField configField;
                    IRfFieldElement key = (IRfFieldElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("adapter") || (value = (IHidObject)entry.getValue()) == null || !(value instanceof RfHid) || (parentElement = ((RfHid)value).getElement()) == null || !(parentElement instanceof RfField)) continue;
                    this.regAdapters.remove(parentElement);
                }
            }
        }

        private void checkConnectCall(RfHid rfHid) {
            IRfNamedElement element;
            RfHid parentHidCall = rfHid;
            do {
                if ((parentHidCall = parentHidCall.getParentHid()) != null) continue;
                return;
            } while (((element = parentHidCall.getElement()) == null || !(element instanceof RfField) || !this.agents.contains(element)) && parentHidCall != null);
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    IRfNamedElement parentElement;
                    Hid parentHid;
                    IHidObject value;
                    RfField configField;
                    IRfFieldElement key = (IRfFieldElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("provider") || (value = (IHidObject)entry.getValue()) == null || !(value instanceof RfHid) || (parentHid = ((RfHid)value).getParentHid()) == null || !(parentHid instanceof RfHid) || (parentElement = parentHid.getElement()) == null || !(parentElement instanceof RfField)) continue;
                    this.regPredictors.remove(parentElement);
                }
            }
        }
    }
}

