/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1296")
@CheckName(value="R.1296")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.PACKAGE, RuleLabel.IMPORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Use sequences imported in the sequence package")
@CheckDescription(value="If inside a package with only sequences (sequence package) there are imports of other packages, the sequences from the sequence package must use sequences from the imported packages.\nThe rule will fail if inside a sequence pacakge there's a wildcard import of another package that contains at least a sequence and no sequence from the imported class is used in the sequence package.\nThis way, you can ensure that any imported VIP will be reused properly.")
@CheckReapplyDisable
public class Check_R_1296
extends OVMComplianceCheck {
    Map<RfPackage, Boolean> packageCache;

    public Check_R_1296(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequence == null) {
            return;
        }
        this.packageCache = new HashMap<RfPackage, Boolean>();
        for (RfPackage pkg : this.fOVMProject.getAllPackages()) {
            NullProtectedList<ImportInfo> importDeclarations;
            if (!this.isSequencePackage(pkg) || (importDeclarations = pkg.getAllImportDeclarations()) == null || importDeclarations.isEmpty()) continue;
            HashMap<RfPackage, ImportInfo> importedPackages = new HashMap<RfPackage, ImportInfo>();
            for (ImportInfo importInfo : importDeclarations) {
                RfPackage rfPackage;
                IRfPackageElement importedPackage;
                if (importInfo instanceof ExplicitImportInfo || !((importedPackage = importInfo.getPackage()) instanceof RfPackage) || !this.packageContainsSequence(rfPackage = (RfPackage)importedPackage)) continue;
                importedPackages.put(rfPackage, importInfo);
            }
            if (importedPackages.isEmpty()) continue;
            IRfNamedElementVisitor neVisitor = namedElement -> {
                if (namedElement instanceof RfClass) {
                    RfClass clazz = (RfClass)namedElement;
                    RfClass parent = clazz.getParent();
                    if (parent == null) {
                        return true;
                    }
                    if (!LintUtils.isSubClassOf(parent, this.fOVMProject.fOvmSequence)) {
                        return true;
                    }
                    RfPackage parentPackage = parent.getEnclosingPackage();
                    importedPackages.remove(parentPackage);
                } else if (namedElement instanceof RfField) {
                    RfField field = (RfField)namedElement;
                    RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                    if (fieldType == null) {
                        return true;
                    }
                    if (!LintUtils.isSubClassOf(fieldType, this.fOVMProject.fOvmSequence)) {
                        return true;
                    }
                    RfPackage fieldPackage = fieldType.getEnclosingPackage();
                    importedPackages.remove(fieldPackage);
                }
                return true;
            };
            pkg.accept(null, neVisitor);
            for (Map.Entry entry : importedPackages.entrySet()) {
                RfPackage importedPackage = (RfPackage)entry.getKey();
                ImportInfo importInfo = (ImportInfo)entry.getValue();
                this.addHit(importInfo.getParserPath(), importInfo.getLine(), "No sequence used from the '" + importedPackage.getName() + "' imported package inside the '" + pkg.getName() + "' sequence package!", null);
            }
        }
    }

    private boolean packageContainsSequence(RfPackage pkg) {
        Boolean cacheResult = this.packageCache.get(pkg);
        if (cacheResult != null) {
            return cacheResult;
        }
        boolean result = false;
        List<RfClass> pkgClasses = pkg.getClassesWithPrefix("", 2, 1);
        if (pkgClasses != null && !pkgClasses.isEmpty()) {
            for (RfClass pkgClass : pkgClasses) {
                if (!LintUtils.isSubClassOf(pkgClass, this.fOVMProject.fOvmSequence)) continue;
                result = true;
                break;
            }
        }
        this.packageCache.put(pkg, result);
        return result;
    }

    private boolean isSequencePackage(RfPackage pkg) {
        List<RfClass> pkgClasses = pkg.getClassesWithPrefix("", 2, 1);
        if (pkgClasses == null || pkgClasses.isEmpty()) {
            return false;
        }
        for (RfClass pkgClass : pkgClasses) {
            if (LintUtils.isSubClassOf(pkgClass, this.fOVMProject.fOvmSequence)) continue;
            return false;
        }
        return true;
    }
}

