/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.26")
@CheckID(value="R.1297")
@CheckName(value="R.1297")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.COMPONENT, RuleLabel.ANALYSIS_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="When making connections between components connect a port directly to an export without any intermediate FIFO")
@CheckDescription(value="The connection between two components should be a direct port-to-export connection. Connecting any port or analysis port to a fifo port (uvm_tlm_fifo family) is not recommended.\n\nExamples:\nmy_agent.port.connect(tlm_fifo.get_export);     // not allowed\nmy_agent.ap.connect(adp.get_ap);                // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1297
extends OVMComplianceCheck {
    private RfClass xvmFifoClass;

    public Check_R_1297(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final String xvmConnectName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base.connect");
        String xvmFifoName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_tlm_fifo");
        this.xvmFifoClass = this.fOVMProject.getRfProject().getClass(xvmFifoName, true);
        if (this.xvmFifoClass == null) {
            this.addHit(null, "Class '" + xvmFifoName + "' not found!");
            return;
        }
        RfHidVisitor callVisitor = new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                String name = LintUtils.getFileShortName(this.parserPath.path);
                if (Check_R_1297.this.fOVMProject.isOVMFile(name)) {
                    return true;
                }
                if (Check_R_1297.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                Check_R_1297.this.notifyCheckAlive();
                if (!((RfFunction)element).getFullName().equals(xvmConnectName)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                block0: for (MethodCall call : methodCalls) {
                    if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                    for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                        RfClass fieldClass;
                        IRfNamedElement parentElement;
                        Hid parentHid;
                        RfField configField;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("provider")) continue;
                        IHidObject value = (IHidObject)entry.getValue();
                        if (!(value instanceof RfHid) || !((parentHid = ((RfHid)value).getParentHid()) instanceof RfHid) || !((parentElement = parentHid.getElement()) instanceof RfField) || (fieldClass = LintUtils.getFieldFinalClassTypeOrNull((RfField)parentElement)) == null || !LintUtils.isSubClassOf(fieldClass, Check_R_1297.this.xvmFifoClass)) continue block0;
                        Check_R_1297.this.addHit(this.parserPath, rfHid, "Connecting the '" + LintUtils.getHidFullName((IHid)rfHid.getParentHid()) + "' port to a FIFO port is not allowed!");
                        continue block0;
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

