/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1298")
@CheckName(value="R.1298")
@CheckLabel(labels={RuleLabel.ANALYSIS_PORT, RuleLabel.TLM_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Use analysis ports and exports when making one-to-many connections")
@CheckDescription(value="TLM ports are a blocking one-to-one connection between components. Connecting one port multiple times is not allowed since it may lead to unexpected behaviour.\nFor multiple connections, analysis ports should be used instead.\n\nExamples:\n\nxvm_blocking_get_port#() port;\n\ncomponent1.port.connect(component2.port);\ncomponent1.port.connect(component3.port);    // not allowed\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1298
extends OVMComplianceCheck {
    private RfClass portBaseClass;
    private String analysisPrefix;

    public Check_R_1298(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String portBaseClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.analysisPrefix = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_");
        this.portBaseClass = this.fOVMProject.getRfProject().getClass(portBaseClassName, true);
        if (this.portBaseClass == null) {
            return;
        }
        LocalVisitor visitor = new LocalVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        Map<RfAssociatedType, Map<ParserPath, Set<HidOccurrence>>> connectedPorts = visitor.getConnectedPorts();
        for (Map.Entry<RfAssociatedType, Map<ParserPath, Set<HidOccurrence>>> entry : connectedPorts.entrySet()) {
            RfAssociatedType assocType = entry.getKey();
            Map<ParserPath, Set<HidOccurrence>> connections = entry.getValue();
            ArrayList connectionsArray = new ArrayList();
            for (Map.Entry<ParserPath, Set<HidOccurrence>> pathEntry : connections.entrySet()) {
                connectionsArray.addAll(pathEntry.getValue());
            }
            if (connectionsArray.size() < 2) continue;
            StringBuilder links = new StringBuilder();
            for (Map.Entry<ParserPath, Set<HidOccurrence>> connectionEntry : connections.entrySet()) {
                ParserPath parserPath = connectionEntry.getKey();
                Set<HidOccurrence> occurrences = connectionEntry.getValue();
                for (HidOccurrence occurrence : occurrences) {
                    links.append(DVTStringUtil.LINE_SEPARATOR).append(this.link(" at line " + occurrence.getLine() + " of " + LintUtils.getFileShortName(parserPath.path), parserPath.path, occurrence.getLine()));
                }
            }
            this.addHit(assocType, "Connecting multiple ports to the '" + LintUtils.getNamedElementFullName(assocType) + "' port is not allowed:" + links.toString());
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalVisitor
    extends RfHidVisitor {
        Map<RfAssociatedType, Map<ParserPath, Set<HidOccurrence>>> connectedPorts = new HashMap<RfAssociatedType, Map<ParserPath, Set<HidOccurrence>>>();

        public boolean visit(RfHid rfHid) {
            Set<HidOccurrence> pathPorts;
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1298.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1298.this.notifyCheckAlive();
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!"connect".equals(function.getName())) {
                return true;
            }
            Hid parentHid = rfHid.getParentHid();
            if (parentHid == null) {
                return true;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfAssociatedType)) {
                return true;
            }
            RfAssociatedType parentAssocType = (RfAssociatedType)parentElement;
            RfNamedElement parentType = LintUtils.getAssociatedFinalType(parentAssocType);
            if (!(parentType instanceof RfClass)) {
                return true;
            }
            RfClass parentClass = (RfClass)parentType;
            if (parentClass.getName().startsWith(Check_R_1298.this.analysisPrefix) || !LintUtils.isSubClassOf(parentClass, Check_R_1298.this.portBaseClass)) {
                return true;
            }
            Map<ParserPath, Set<HidOccurrence>> ports = this.connectedPorts.get(parentAssocType);
            if (ports == null) {
                ports = new LinkedHashMap<ParserPath, Set<HidOccurrence>>();
                this.connectedPorts.put(parentAssocType, ports);
            }
            if ((pathPorts = ports.get(this.parserPath)) == null) {
                pathPorts = new HashSet<HidOccurrence>();
                ports.put(this.parserPath, pathPorts);
            }
            pathPorts.add(rfHid.getOccurrence());
            return true;
        }

        public Map<RfAssociatedType, Map<ParserPath, Set<HidOccurrence>>> getConnectedPorts() {
            return this.connectedPorts;
        }
    }
}

