/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.3")
@CheckID(value="R.1299")
@CheckName(value="R.1299")
@CheckLabel(labels={RuleLabel.ANALYSIS_PORT, RuleLabel.SUBSCRIBER, RuleLabel.VERIFICATION})
@CheckTitle(value="Analysis ports of subscribers must be connected and must have the corresponding write method implemented")
@CheckDescription(value="All analysis ports of subscribers must be connected to another imp port and the corresponding connected port must have the write method implemented.\n\nExamples:\nclass my_subscriber extends xvm_subscriber#();\n\txvm_analysis_imp_ahb#() ap_ahb;  // not allowed, not connected\n\txvm_analysis_imp_rhb#() ap_rhb;  // not allowed, connected port 'ap_req' doesn't implement write method\n\txvm_analysis_imp_bus#() ap_bus;  // allowed, connected port 'ap_hub' implements write method\n  my_scoreboard scoreboard;\n\n  virtual function void connect_phase(uvm_phase phase);\n\t  super.connect_phase(phase);\n\t  ap_rhb.connect(scoreboard.ap_req);\n\t  ap_bus.connect(scoreboard.ap_hub);\n\tendfunction : connect_phase\n\nendclass\n\nclass my_scoreboard extends xvm_scoreboard#();\n  uvm_analysis_imp_req#() ap_req;\n  uvm_analysis_imp_hub#() ap_hub;\n\n  virtual function void write_hub(int t);\n  endfunction : write_hub\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1299
extends OVMComplianceCheck {
    private String analysis;
    private String analysisImpNamePrefix;
    private RfClass portBaseClass;

    public Check_R_1299(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String subscriberBaseClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_subscriber");
        RfClass subscriberBaseClass = this.fOVMProject.getRfProject().getClass(subscriberBaseClassName, true);
        String portBaseClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.analysis = "_analysis_";
        this.analysisImpNamePrefix = "uvm_analysis_imp";
        this.portBaseClass = this.fOVMProject.getRfProject().getClass(portBaseClassName, true);
        if (subscriberBaseClass == null || this.portBaseClass == null) {
            return;
        }
        Set<RfClass> allSubscribers = this.fOVMProject.getAllXVMSubClasses(subscriberBaseClass);
        if (allSubscribers.isEmpty()) {
            return;
        }
        final HashSet<RfField> allAnalysisPorts = new HashSet<RfField>();
        for (RfClass subscriber : allSubscribers) {
            Set<RfField> analysisPorts;
            if (this.checkPreWaivers(subscriber.getDeclaration().getParserPath())) continue;
            this.notifyCheckAlive();
            List<RfField> fields = subscriber.getLocalFields();
            if (fields.isEmpty() || (analysisPorts = this.getAnalysisPorts(fields)).isEmpty()) continue;
            allAnalysisPorts.addAll(analysisPorts);
        }
        if (allAnalysisPorts.isEmpty()) {
            return;
        }
        final HashMap originalPortToConnectedAnalysisPorts = new HashMap();
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1299.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1299.this.notifyCheckAlive();
                IRfNamedElement element = rfHid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!"connect".equals(function.getName())) {
                    return true;
                }
                Hid parentHid = rfHid.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement parentElement = parentHid.getElement();
                if (!(parentElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)parentElement;
                if (!(rfHid.getFirstAccess() instanceof RfHidAccessArgs)) {
                    return true;
                }
                List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)rfHid.getFirstAccess()).getArgumentValues();
                if (argumentValues == null || argumentValues.size() != 1) {
                    return true;
                }
                IHidObject arg = argumentValues.get(0);
                if (!(arg instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator argOperator = (RfHidOperator)arg;
                IHidObject lhHidObj = argOperator.getLHValue();
                if (!(lhHidObj instanceof RfHid)) {
                    return true;
                }
                RfHid lhHid = (RfHid)lhHidObj;
                if (!(lhHid.getElement() instanceof RfField)) {
                    return true;
                }
                if (!lhHid.getElement().getName().equals("provider")) {
                    return true;
                }
                if (!(argOperator.getFirstRHValue() instanceof RfHid)) {
                    return true;
                }
                RfHid firstRhHid = (RfHid)((RfHidOperator)arg).getFirstRHValue();
                if (!(firstRhHid.getElement() instanceof RfField)) {
                    return true;
                }
                if (allAnalysisPorts.remove(field) || originalPortToConnectedAnalysisPorts.containsKey(field)) {
                    originalPortToConnectedAnalysisPorts.putIfAbsent(field, new ArrayList());
                    ((List)originalPortToConnectedAnalysisPorts.get(field)).add((RfField)firstRhHid.getElement());
                }
                return true;
            }
        });
        for (RfField rfField : allAnalysisPorts) {
            this.addHit(rfField, "Subscriber analysis port '" + LintUtils.getNamedElementFullName(rfField) + "' is not connected!");
        }
        for (Map.Entry entry : originalPortToConnectedAnalysisPorts.entrySet()) {
            for (RfField connectedPortTo : (List)entry.getValue()) {
                this.analyzePortForWriteMethod((RfField)entry.getKey(), connectedPortTo);
            }
        }
    }

    private void analyzePortForWriteMethod(RfField portConnectedFrom, RfField portConnectedTo) {
        RfClass portClass = portConnectedTo.getEnclosingScope(RfClass.class);
        if (portClass == null) {
            return;
        }
        RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(portConnectedTo);
        if (fieldType == null) {
            return;
        }
        if (!LintUtils.isSubClassOf(fieldType, this.portBaseClass) || !fieldType.getName().startsWith(this.analysisImpNamePrefix)) {
            this.addHit(portConnectedFrom, "Subscriber analysis port '" + LintUtils.getNamedElementFullName(portConnectedFrom) + "' is connected but not to a port of type '" + this.analysisImpNamePrefix + "'!");
            return;
        }
        List<RfFunction> writeMethods = portClass.getFunctionsWithPrefix("write", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (writeMethods != null) {
            for (RfFunction method : writeMethods) {
                String methodSufix = method.getName().substring("write".length());
                if (methodSufix.isEmpty() || !fieldType.getName().endsWith(methodSufix)) continue;
                return;
            }
        }
        this.addHit(portConnectedFrom, "Subscriber analysis port '" + LintUtils.getNamedElementFullName(portConnectedFrom) + "' is connected to implementation port '" + LintUtils.getNamedElementFullName(portConnectedTo) + "' but doesn't have a write method implemented in class '" + LintUtils.getNamedElementFullName(portClass) + "'!");
    }

    private Set<RfField> getAnalysisPorts(List<RfField> fields) {
        HashSet<RfField> result = new HashSet<RfField>();
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType == null || !fieldType.getName().contains(this.analysis) || !LintUtils.isSubClassOf(fieldType, this.portBaseClass)) continue;
            result.add(field);
        }
        return result;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

